/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.network.packet;

import com.hammy275.immersivemc.api.common.immersive.ImmersiveHandler;
import com.hammy275.immersivemc.api.common.immersive.NetworkStorage;
import com.hammy275.immersivemc.common.immersive.handler.ImmersiveHandlers;
import com.hammy275.immersivemc.common.network.NetworkClientHandlers;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class FetchInventoryPacket<S extends NetworkStorage> {
    public final S storage;
    public final ImmersiveHandler<S> handler;
    public final BlockPos pos;

    public FetchInventoryPacket(ImmersiveHandler<S> handler, S storage, BlockPos pos) {
        this.handler = handler;
        this.storage = storage;
        this.pos = pos;
    }

    public static <NS extends NetworkStorage> void encode(FetchInventoryPacket<NS> packet, FriendlyByteBuf buffer) {
        buffer.m_130064_(packet.pos);
        buffer.m_130085_(packet.handler.getID());
        packet.storage.encode(buffer);
    }

    public static <NS extends NetworkStorage> FetchInventoryPacket<NS> decode(FriendlyByteBuf buffer) {
        BlockPos pos = buffer.m_130135_();
        ImmersiveHandler<?> handlerToSet = null;
        NetworkStorage storage = null;
        ResourceLocation id = buffer.m_130281_();
        for (ImmersiveHandler<?> handler : ImmersiveHandlers.HANDLERS) {
            if (!handler.getID().equals((Object)id)) continue;
            handlerToSet = handler;
            storage = (NetworkStorage)handlerToSet.getEmptyNetworkStorage();
            storage.decode(buffer);
            break;
        }
        if (storage == null) {
            throw new IllegalArgumentException("ID " + id + " not found!");
        }
        return new FetchInventoryPacket<Object>((ImmersiveHandler<Object>)handlerToSet, storage, pos);
    }

    public static <NS extends NetworkStorage> void handle(FetchInventoryPacket<NS> message, ServerPlayer player) {
        if (player == null) {
            NetworkClientHandlers.handleReceiveInvData(message.storage, message.pos, message.handler);
        }
    }
}

