/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.immersive.storage.dual.impl;

import com.hammy275.immersivemc.api.common.immersive.NetworkStorage;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.util.Util;
import com.hammy275.immersivemc.server.ServerUtil;
import com.hammy275.immersivemc.server.storage.server.ItemSwapAmount;
import com.hammy275.immersivemc.server.storage.server.SwapResult;
import com.hammy275.immersivemc.server.storage.world.WorldStorage;
import com.hammy275.immersivemc.server.storage.world.WorldStoragesImpl;
import com.hammy275.immersivemc.server.swap.Swap;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Stack;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public abstract class ItemStorage
implements WorldStorage,
NetworkStorage {
    protected ItemStack[] items;
    protected List<PlayerItemCounts>[] itemCounts;
    protected boolean isDirtyForClientSync = false;
    public final int maxInputIndex;

    public ItemStorage(int numItems, int maxInputIndex) {
        this.items = new ItemStack[numItems];
        Arrays.fill(this.items, ItemStack.f_41583_);
        this.itemCounts = new LinkedList[numItems];
        for (int i = 0; i < numItems; ++i) {
            this.itemCounts[i] = new LinkedList<PlayerItemCounts>();
        }
        this.maxInputIndex = maxInputIndex;
    }

    public boolean isDirtyForClientSync() {
        return this.isDirtyForClientSync;
    }

    public void setDirty(ServerLevel level) {
        WorldStoragesImpl.markDirtyS(level);
        this.isDirtyForClientSync = true;
    }

    public void setNoLongerDirtyForClientSync() {
        this.isDirtyForClientSync = false;
    }

    public void setItem(int slot, ItemStack stack) {
        this.items[slot] = stack;
        this.itemCounts[slot].clear();
    }

    public void setItem(int slot, ItemStack stack, Player player) {
        this.setItem(slot, stack);
        this.incrementCountForPlayer(player, stack.m_41613_(), slot);
    }

    public void shrinkSlot(int slot, int amount) {
        this.items[slot].m_41774_(amount);
        this.shrinkCountsOnly(slot, amount);
    }

    public void shrinkCountsOnly(int slot, int amount) {
        while (amount > 0 && !this.itemCounts[slot].isEmpty()) {
            PlayerItemCounts counts = this.itemCounts[slot].get(0);
            int toSubtract = Math.min(amount, counts.count);
            amount -= toSubtract;
            counts.count -= toSubtract;
            if (counts.count != 0) continue;
            this.itemCounts[slot].remove(0);
        }
    }

    public void placeItem(Player player, InteractionHand hand, int slot, ItemSwapAmount amount) {
        this.placeItem(player, hand, slot, amount, -1);
    }

    public void placeItem(Player player, InteractionHand hand, int slot, ItemSwapAmount amount, int forcedMaxImmersiveStackSize) {
        ItemStack playerStack = player.m_21120_(hand);
        ItemStack otherStack = this.getItem(slot);
        SwapResult result = Swap.swapItems(playerStack, otherStack, amount, forcedMaxImmersiveStackSize, player, incrementAmount -> this.incrementCountForPlayer(player, (int)incrementAmount, slot), ignored -> this.itemCounts[slot].clear());
        result.giveToPlayer(player, hand);
        this.items[slot] = result.immersiveStack();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            this.setDirty(sp.m_284548_());
        }
    }

    public void incrementCountForPlayer(Player player, int amount, int slot) {
        PlayerItemCounts last;
        boolean shouldReturnItems = ActiveConfig.getConfigForPlayer((Player)player).returnItemsWhenLeavingImmersives;
        PlayerItemCounts playerItemCounts = last = this.itemCounts[slot].isEmpty() ? null : this.itemCounts[slot].get(this.itemCounts[slot].size() - 1);
        if (last != null && shouldReturnItems && last.uuid.isPresent() && last.uuid.get().equals(player.m_20148_())) {
            last.count += amount;
        } else if (shouldReturnItems) {
            this.itemCounts[slot].add(new PlayerItemCounts(Optional.of(player.m_20148_()), amount));
        } else if (last != null && last.uuid.isEmpty()) {
            last.count += amount;
        } else {
            this.itemCounts[slot].add(new PlayerItemCounts(Optional.empty(), amount));
        }
    }

    public ItemStack getItem(int slot) {
        return this.items[slot];
    }

    public int getNumItems() {
        return this.items.length;
    }

    public ItemStack[] getItemsRaw() {
        return this.items;
    }

    public void copyFromOld(ItemStorage oldStorage) {
        this.items = oldStorage.items;
        this.itemCounts = oldStorage.itemCounts;
    }

    public void returnItems(Player player) {
        for (int slot = 0; slot < this.itemCounts.length; ++slot) {
            Stack<Integer> countsToRemove = new Stack<Integer>();
            for (int countIndex = 0; countIndex < this.itemCounts[slot].size(); ++countIndex) {
                PlayerItemCounts counts = this.itemCounts[slot].get(countIndex);
                if (!counts.uuid.isPresent() || !counts.uuid.get().equals(player.m_20148_())) continue;
                countsToRemove.add(countIndex);
                ItemStack ret = this.items[slot].m_41777_();
                ret.m_41764_(counts.count);
                Util.placeLeftovers(player, ret);
                this.items[slot].m_41774_(counts.count);
            }
            while (!countsToRemove.isEmpty()) {
                this.itemCounts[slot].remove((Integer)countsToRemove.pop());
            }
        }
    }

    @Override
    public void load(CompoundTag nbt, int lastVanillaDataVersion) {
        int i;
        int length = nbt.m_128451_("numOfItems");
        this.items = new ItemStack[length];
        for (i = 0; i < length; ++i) {
            this.items[i] = ServerUtil.parseItem(nbt.m_128469_("item" + i), lastVanillaDataVersion);
        }
        this.itemCounts = new LinkedList[length];
        for (i = 0; i < length; ++i) {
            this.itemCounts[i] = new LinkedList<PlayerItemCounts>();
        }
        if (nbt.m_128441_("itemCounts")) {
            CompoundTag rootCounts = nbt.m_128469_("itemCounts");
            for (int i2 = 0; i2 < length; ++i2) {
                CompoundTag slotTag = rootCounts.m_128469_("slot" + i2);
                int numOfCounts = slotTag.m_128451_("numOfItems");
                for (int j = 0; j < numOfCounts; ++j) {
                    this.itemCounts[i2].add(PlayerItemCounts.load(slotTag.m_128469_(String.valueOf(j))));
                }
            }
        }
    }

    @Override
    public CompoundTag save(CompoundTag nbt) {
        nbt.m_128405_("numOfItems", this.items.length);
        for (int i = 0; i < this.items.length; ++i) {
            nbt.m_128365_("item" + i, (Tag)this.items[i].m_41739_(new CompoundTag()));
        }
        CompoundTag rootCounts = new CompoundTag();
        for (int slot = 0; slot < this.itemCounts.length; ++slot) {
            CompoundTag countSlot = new CompoundTag();
            countSlot.m_128405_("numOfItems", this.itemCounts[slot].size());
            for (int countIndex = 0; countIndex < this.itemCounts[slot].size(); ++countIndex) {
                PlayerItemCounts count = this.itemCounts[slot].get(countIndex);
                countSlot.m_128365_(String.valueOf(countIndex), (Tag)count.save());
            }
            rootCounts.m_128365_("slot" + slot, (Tag)countSlot);
        }
        nbt.m_128365_("itemCounts", (Tag)rootCounts);
        return nbt;
    }

    public void moveSlot(int oldSlot, int newSlot) {
        this.items[newSlot] = this.items[oldSlot];
        this.itemCounts[newSlot] = this.itemCounts[oldSlot];
        this.items[oldSlot] = ItemStack.f_41583_;
        this.itemCounts[oldSlot] = new LinkedList<PlayerItemCounts>();
    }

    public void addSlotsToEnd(int slotsToAdd) {
        int i;
        ItemStack[] oldItems = this.items;
        List<PlayerItemCounts>[] oldItemCounts = this.itemCounts;
        this.items = new ItemStack[oldItems.length + slotsToAdd];
        Arrays.fill(this.items, ItemStack.f_41583_);
        this.itemCounts = new LinkedList[oldItemCounts.length + slotsToAdd];
        for (i = 0; i < oldItems.length; ++i) {
            this.items[i] = oldItems[i];
        }
        for (i = 0; i < oldItemCounts.length; ++i) {
            this.itemCounts[i] = oldItemCounts[i];
        }
        for (i = oldItemCounts.length; i < this.itemCounts.length; ++i) {
            this.itemCounts[i] = new LinkedList<PlayerItemCounts>();
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        for (ItemStack item : this.items) {
            buffer.m_130055_(item);
        }
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i] = buffer.m_130267_();
        }
    }

    public static class PlayerItemCounts {
        public final Optional<UUID> uuid;
        public int count;

        public PlayerItemCounts(Optional<UUID> uuid, int count) {
            this.uuid = uuid;
            this.count = count;
        }

        public CompoundTag save() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("uuid", this.uuid.isEmpty() ? "null" : this.uuid.get().toString());
            nbt.m_128405_("count", this.count);
            return nbt;
        }

        public static PlayerItemCounts load(CompoundTag nbt) {
            String uuidString = nbt.m_128461_("uuid");
            UUID uuid = uuidString.equals("null") || uuidString.isEmpty() ? null : UUID.fromString(uuidString);
            int count = nbt.m_128451_("count");
            return new PlayerItemCounts(Optional.ofNullable(uuid), count);
        }
    }
}

