/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.config;

import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.config.ClientActiveConfig;
import com.hammy275.immersivemc.common.config.ItemGuideColorData;
import com.hammy275.immersivemc.common.util.MemoizedSupplier;
import com.hammy275.immersivemc.common.util.RGBA;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public enum ItemGuidePreset {
    GRAY(new ItemGuideColorData(new MemoizedSupplier<List<RGBA>>(List.of(new RGBA(1670089611L))), new MemoizedSupplier<List<RGBA>>(List.of(new RGBA(2143667653L))), new MemoizedSupplier<List<RGBA>>(List.of(new RGBA(2143667653L))), () -> ClientActiveConfig.FILE_CLIENT.colorPresetRangedGrabSize)),
    CLASSIC(new ItemGuideColorData(new MemoizedSupplier<List<RGBA>>(List.of(new RGBA(0x3300FFFFL))), new MemoizedSupplier<List<RGBA>>(List.of(new RGBA(0x3300FF00L))), new MemoizedSupplier<List<RGBA>>(List.of(new RGBA(65535L))), () -> ClientActiveConfig.FILE_CLIENT.colorPresetRangedGrabSize)),
    PRIDE_FLAG(() -> ClientActiveConfig.FILE_CLIENT.itemGuidePrideFlag.multiColorPresetHolder.colorData),
    CUSTOM(() -> ClientActiveConfig.FILE_CLIENT.itemGuideCustomColorData);

    public final Supplier<ItemGuideColorData> colorData;

    private ItemGuidePreset(ItemGuideColorData colorData) {
        this(() -> colorData);
    }

    private ItemGuidePreset(Supplier<ItemGuideColorData> colorData) {
        this.colorData = colorData;
    }

    public boolean showTransitionConfig() {
        return this == PRIDE_FLAG || this == CUSTOM;
    }

    public boolean isCustomizablePreset() {
        return this == PRIDE_FLAG;
    }

    public static enum PrideFlag {
        PRIDE(List.of(Integer.valueOf(14942979), Integer.valueOf(16747520), Integer.valueOf(16772352), Integer.valueOf(32806), Integer.valueOf(2375822), Integer.valueOf(7547266))),
        ASEXUAL(List.of(Integer.valueOf(0), Integer.valueOf(0xA3A3A3), Integer.valueOf(0xFFFFFF), Integer.valueOf(0x800080))),
        BISEXUAL(List.of(Integer.valueOf(14025328), Integer.valueOf(14025328), Integer.valueOf(10178454), Integer.valueOf(14504), Integer.valueOf(14504))),
        GAY(List.of(Integer.valueOf(494960), Integer.valueOf(2543274), Integer.valueOf(10021057), Integer.valueOf(0xFFFFFF), Integer.valueOf(8105442), Integer.valueOf(5261772), Integer.valueOf(4004472))),
        LESBIAN(List.of(Integer.valueOf(13970688), Integer.valueOf(15693351), Integer.valueOf(16751190), Integer.valueOf(0xFFFFFF), Integer.valueOf(13722276), Integer.valueOf(11884176), Integer.valueOf(10682978))),
        NONBINARY(List.of(Integer.valueOf(16577588), Integer.valueOf(0xFFFFFF), Integer.valueOf(10246609), Integer.valueOf(0x2C2C2C))),
        PANSEXUAL(List.of(Integer.valueOf(16720268), Integer.valueOf(16766976), Integer.valueOf(2208255))),
        TRANSGENDER(List.of(Integer.valueOf(6016762), Integer.valueOf(16099768), Integer.valueOf(0xFFFFFF), Integer.valueOf(16099768), Integer.valueOf(6016762)));

        public final MultiColorPresetHolder multiColorPresetHolder;

        private PrideFlag(List<Integer> colors) {
            this.multiColorPresetHolder = new MultiColorPresetHolder(colors.stream().map(RGBA::new).toList());
        }
    }

    public static class MultiColorPresetHolder {
        private final List<RGBA> colors;
        private final List<RGBA> selectedColors;
        private final List<RGBA> rangedGrabColors;
        public final ItemGuideColorData colorData;
        private int lastAlpha = -1;
        private int lastSelectedAlpha = -1;
        private int lastRangedGrabAlpha = -1;

        public MultiColorPresetHolder(List<RGBA> colors) {
            this.colors = new ArrayList<RGBA>(colors);
            this.selectedColors = new ArrayList<RGBA>(colors);
            this.rangedGrabColors = new ArrayList<RGBA>(colors);
            this.colorData = new ItemGuideColorData(() -> {
                int newAlpha = ActiveConfig.FILE_CLIENT.colorPresetAlpha;
                if (this.lastAlpha != newAlpha) {
                    this.colors.replaceAll(color -> new RGBA(color.getRGB(), newAlpha));
                    this.lastAlpha = newAlpha;
                }
                return this.colors;
            }, () -> {
                int newAlpha = ActiveConfig.FILE_CLIENT.colorPresetSelectedAlpha;
                if (this.lastSelectedAlpha != newAlpha) {
                    this.selectedColors.replaceAll(color -> new RGBA(color.getRGB(), newAlpha));
                    this.lastSelectedAlpha = newAlpha;
                }
                return this.selectedColors;
            }, () -> {
                int newAlpha = ActiveConfig.FILE_CLIENT.colorPresetRangedGrabSize;
                if (this.lastRangedGrabAlpha != newAlpha) {
                    this.rangedGrabColors.replaceAll(color -> new RGBA(color.getRGB(), newAlpha));
                    this.lastRangedGrabAlpha = newAlpha;
                }
                return this.rangedGrabColors;
            }, () -> ActiveConfig.FILE_CLIENT.multiColorPresetTransitionTimeMS);
        }
    }
}

