/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.hammy275.immersivemc.common.config.ItemGuidePreset;
import com.hammy275.immersivemc.common.util.MemoizedSupplier;
import com.hammy275.immersivemc.common.util.RGBA;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public record ItemGuideColorData(Supplier<List<RGBA>> colors, Supplier<List<RGBA>> selectedColors, Supplier<List<RGBA>> rangedGrabColors, Supplier<Integer> transitionTimeMS) {
    public static final ItemGuideColorData DEFAULT_CUSTOM = new ItemGuideColorData(new MemoizedSupplier<Supplier<List>>(() -> ItemGuidePreset.GRAY.colorData.get().colors.get()), new MemoizedSupplier<Supplier<List>>(() -> ItemGuidePreset.GRAY.colorData.get().selectedColors.get()), new MemoizedSupplier<Supplier<List>>(() -> ItemGuidePreset.GRAY.colorData.get().rangedGrabColors.get()), () -> 5000);

    public static ItemGuideColorData of(Supplier<RGBA> color, Supplier<RGBA> selectedColor, Supplier<RGBA> rangedGrabColor) {
        return new ItemGuideColorData(() -> List.of((RGBA)((Object)((Object)color.get()))), () -> List.of((RGBA)((Object)((Object)selectedColor.get()))), () -> List.of((RGBA)((Object)((Object)rangedGrabColor.get()))), () -> 0);
    }

    public static ItemGuideColorData of(List<RGBA> colors, List<RGBA> selectedColors, List<RGBA> rangedGrabColors, int transitionTimeMS) {
        return new ItemGuideColorData(() -> colors, () -> selectedColors, () -> rangedGrabColors, () -> transitionTimeMS);
    }

    public ItemGuideColorData withChangedTransitionTime(int newTransitionTimeMS) {
        return new ItemGuideColorData(this.colors, this.selectedColors, this.rangedGrabColors, () -> newTransitionTimeMS);
    }

    public static class GsonHandler
    implements JsonSerializer<ItemGuideColorData>,
    JsonDeserializer<ItemGuideColorData> {
        public JsonElement serialize(ItemGuideColorData src, Type typeOfSrc, JsonSerializationContext context) {
            List<RGBA> colors = src.colors.get();
            List<RGBA> selectedColors = src.selectedColors.get();
            List<RGBA> rangedGrabColors = src.rangedGrabColors.get();
            JsonObject json = new JsonObject();
            JsonArray colorsArray = new JsonArray(colors.size());
            JsonArray selectedColorsArray = new JsonArray(selectedColors.size());
            JsonArray rangedGrabColorsArray = new JsonArray(rangedGrabColors.size());
            colors.forEach(col -> colorsArray.add(context.serialize((Object)col)));
            selectedColors.forEach(col -> selectedColorsArray.add(context.serialize((Object)col)));
            rangedGrabColors.forEach(col -> rangedGrabColorsArray.add(context.serialize((Object)col)));
            json.add("colors", (JsonElement)colorsArray);
            json.add("selectedColors", (JsonElement)selectedColorsArray);
            json.add("rangedGrabColors", (JsonElement)rangedGrabColorsArray);
            json.addProperty("transitionTimeMS", (Number)src.transitionTimeMS.get());
            return json;
        }

        public ItemGuideColorData deserialize(JsonElement jsonElem, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject json = jsonElem.getAsJsonObject();
            JsonArray colorsArray = json.getAsJsonArray("colors");
            JsonArray selectedColorsArray = json.getAsJsonArray("selectedColors");
            JsonArray rangedGrabColorsArray = json.getAsJsonArray("rangedGrabColors");
            ArrayList<RGBA> colors = new ArrayList<RGBA>();
            ArrayList<RGBA> selectedColors = new ArrayList<RGBA>();
            ArrayList<RGBA> rangedGrabColors = new ArrayList<RGBA>();
            colorsArray.forEach(colElem -> colors.add((RGBA)((Object)((Object)context.deserialize(colElem, RGBA.class)))));
            selectedColorsArray.forEach(colElem -> selectedColors.add((RGBA)((Object)((Object)context.deserialize(colElem, RGBA.class)))));
            rangedGrabColorsArray.forEach(colElem -> rangedGrabColors.add((RGBA)((Object)((Object)context.deserialize(colElem, RGBA.class)))));
            int transitionTimeMS = json.get("transitionTimeMS").getAsInt();
            return ItemGuideColorData.of(colors, selectedColors, rangedGrabColors, transitionTimeMS);
        }
    }
}

