/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.config;

import com.hammy275.immersivemc.Platform;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.config.ClientActiveConfig;
import java.io.File;
import java.nio.file.Paths;

public enum ConfigType {
    CLIENT(Paths.get(Platform.getConfigFolder().toString(), "immersive_mc-client.json").toFile(), ClientActiveConfig.class),
    SERVER(Paths.get(Platform.getConfigFolder().toString(), "immersive_mc-server.json").toFile(), ActiveConfig.class);

    public final File configFile;
    public final Class<? extends ActiveConfig> configClass;

    private ConfigType(File configFile, Class<? extends ActiveConfig> configClass) {
        this.configFile = configFile;
        this.configClass = configClass;
    }

    public ActiveConfig getDefaultConfig() {
        try {
            return this.configClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean neededOnSide() {
        return Platform.isClient() || this == SERVER;
    }
}

