/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.compat;

import com.hammy275.immersivemc.common.compat.CompatData;
import com.hammy275.immersivemc.common.compat.util.CompatUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;

public class IronFurnaces {
    public static final Class<?> ironFurnaceTileBase = CompatUtils.getClazz("ironfurnaces.tileentity.furnaces.BlockIronFurnaceTileBase");
    public static final CompatData compatData = new CompatData("Iron Furnaces' Furnaces", (config, newVal) -> {
        config.useIronFurnacesFurnaceImmersive = newVal;
    });
    private static final Method unlockRecipes = IronFurnaces.findUnlockRecipesMethod();

    private static Method findUnlockRecipesMethod() {
        Method method = CompatUtils.getMethod(ironFurnaceTileBase, "unlockRecipes", ServerPlayer.class);
        if (method == null) {
            method = CompatUtils.getMethod(ironFurnaceTileBase, "unlockRecipes", Player.class);
        }
        return method;
    }

    public static void doUnlockRecipes(WorldlyContainer furnace, ServerPlayer player) {
        if (ironFurnaceTileBase.isInstance(furnace) && unlockRecipes != null) {
            try {
                unlockRecipes.invoke((Object)furnace, player);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
    }
}

