/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.api_impl.hitbox;

import com.hammy275.immersivemc.api.common.hitbox.BoundingBox;
import com.hammy275.immersivemc.api.common.hitbox.OBB;
import com.hammy275.immersivemc.common.obb.OBBRotList;
import com.hammy275.immersivemc.common.obb.RotType;
import java.util.Optional;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class OBBImpl
implements BoundingBox,
OBB {
    private static final double HALFSQRT2 = Math.sqrt(2.0) / 2.0;
    final AABB aabb;
    final Vec3 center;
    final Vector3f centerF;
    final Quaternionf rotation;

    public OBBImpl(AABB aabb) {
        this(aabb, new Quaternionf());
    }

    public OBBImpl(AABB aabb, double pitch, double yaw, double roll) {
        this(aabb, OBBRotList.create().addRot(yaw, RotType.YAW).addRot(pitch, RotType.PITCH).addRot(roll, RotType.ROLL).asQuaternion());
    }

    public OBBImpl(AABB aabb, Quaternionf rotation) {
        this.aabb = aabb;
        this.center = aabb.m_82399_();
        this.centerF = this.center.m_252839_();
        this.rotation = rotation;
    }

    @Override
    public boolean contains(Vec3 point) {
        Vector3f pt = point.m_252839_();
        pt = pt.sub((Vector3fc)this.centerF).rotate((Quaternionfc)this.rotation).add((Vector3fc)this.centerF);
        return this.aabb.m_82390_(this.toVec3(pt));
    }

    @Override
    public Optional<Vec3> rayHit(Vec3 rayStart, Vec3 rayEnd) {
        Vec3 dir = rayEnd.m_82546_(rayStart).m_82541_();
        double dist = rayStart.m_82554_(rayEnd);
        Vector3f dirF = dir.m_252839_().rotate((Quaternionfc)this.rotation);
        Vector3f rayStartF = rayStart.m_252839_().sub((Vector3fc)this.centerF).rotate((Quaternionfc)this.rotation).add((Vector3fc)this.centerF);
        Optional intersect = this.aabb.m_82371_(this.toVec3(rayStartF), this.toVec3(rayStartF.add((Vector3fc)dirF.mul((float)dist))));
        if (intersect.isPresent()) {
            return Optional.of(this.toVec3(((Vec3)intersect.get()).m_252839_().sub((Vector3fc)this.centerF).rotate((Quaternionfc)this.rotation).add((Vector3fc)this.centerF)));
        }
        return Optional.empty();
    }

    @Override
    public AABB getUnderlyingAABB() {
        return this.aabb;
    }

    @Override
    public Vec3 getCenter() {
        return this.center;
    }

    @Override
    public Quaternionf getRotation() {
        return new Quaternionf((Quaternionfc)this.rotation);
    }

    @Override
    public AABB getEnclosingAABB() {
        double maxSize = Math.max(Math.max(this.aabb.m_82362_(), this.aabb.m_82376_()), this.aabb.m_82385_());
        return this.aabb.m_82400_(maxSize * HALFSQRT2);
    }

    @Override
    public OBB move(Vec3 movement) {
        return new OBBImpl(this.aabb.m_82383_(movement), this.rotation);
    }

    @Override
    public OBBImpl asOBB() {
        return this;
    }

    @Override
    public AABB asAABB() {
        throw new RuntimeException("Cannot get AABB as OBB!");
    }

    private Vec3 toVec3(Vector3f vec3f) {
        return new Vec3((double)vec3f.x(), (double)vec3f.y(), (double)vec3f.z());
    }
}

