/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.api_impl;

import com.hammy275.immersivemc.api.common.ImmersiveMCMeta;

public class ImmersiveMCMetaImpl
implements ImmersiveMCMeta {
    public static final ImmersiveMCMeta INSTANCE = new ImmersiveMCMetaImpl();

    @Override
    public boolean compatibleWithAPIVersion(String builtVersion) throws IllegalArgumentException {
        String[] vers = builtVersion.split("\\.");
        if (vers.length != 2) {
            this.throwBadVersion();
        }
        try {
            int major = Integer.parseInt(vers[0]);
            int minor = Integer.parseInt(vers[1]);
            return major == this.getMajorAPIVersion() && minor >= this.getMinorAPIVersion();
        }
        catch (NumberFormatException e) {
            this.throwBadVersion();
            return false;
        }
    }

    private void throwBadVersion() {
        throw new IllegalArgumentException("Version string must be of the format x.y where x and y are integers.");
    }

    @Override
    public String getAPIVersion() {
        return "%d.%d".formatted(this.getMajorAPIVersion(), this.getMinorAPIVersion());
    }

    @Override
    public int getMajorAPIVersion() {
        return 2;
    }

    @Override
    public int getMinorAPIVersion() {
        return 0;
    }
}

