/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.subscribe;

import com.hammy275.immersivemc.Platform;
import com.hammy275.immersivemc.api.client.immersive.Immersive;
import com.hammy275.immersivemc.api.client.immersive.ImmersiveInfo;
import com.hammy275.immersivemc.api.common.hitbox.BoundingBox;
import com.hammy275.immersivemc.api.common.immersive.NetworkStorage;
import com.hammy275.immersivemc.client.immersive.AbstractPlayerAttachmentImmersive;
import com.hammy275.immersivemc.client.immersive.Immersives;
import com.hammy275.immersivemc.client.immersive.SwapTracker;
import com.hammy275.immersivemc.client.immersive.info.AbstractPlayerAttachmentInfo;
import com.hammy275.immersivemc.client.subscribe.ClientLogicSubscriber;
import com.hammy275.immersivemc.common.util.Util;
import com.hammy275.immersivemc.common.vr.VRPlugin;
import java.util.List;
import java.util.Optional;
import net.blf02.vrapi.api.data.IVRData;
import net.blf02.vrapi.api.data.IVRPlayer;
import net.minecraft.client.Minecraft;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class ClientVRSubscriber {
    protected static int cooldown = 0;

    public static void setCooldown(int cooldown) {
        cooldown = cooldown == 0 ? 1 : cooldown;
        ClientVRSubscriber.cooldown = Math.max(ClientVRSubscriber.cooldown, cooldown);
    }

    public static int getCooldown() {
        return cooldown;
    }

    public static void immersiveTickVR(Player player) {
        if (!Platform.isClient()) {
            return;
        }
        if (Minecraft.m_91087_().f_91072_ == null) {
            return;
        }
        if (!VRPlugin.API.playerInVR(player)) {
            return;
        }
        IVRPlayer vrPlayer = VRPlugin.API.getVRPlayer(player);
        double dist = Minecraft.m_91087_().f_91072_.m_105286_();
        Vec3 start = vrPlayer.getHMD().position();
        Vec3 look = vrPlayer.getHMD().getLookAngle();
        Vec3 end = vrPlayer.getHMD().position().m_82520_(look.f_82479_ * dist, look.f_82480_ * dist, look.f_82481_ * dist);
        BlockHitResult res = player.m_9236_().m_45547_(new ClipContext(start, end, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        ClientLogicSubscriber.possiblyTrack(res.m_82425_(), player.m_9236_().m_8055_(res.m_82425_()), player.m_9236_().m_7702_(res.m_82425_()), (Level)Minecraft.m_91087_().f_91073_);
        if (cooldown > 0) {
            --cooldown;
        }
        for (int c = 0; c <= 1; ++c) {
            for (Immersive<? extends ImmersiveInfo, ? extends NetworkStorage> singleton : Immersives.IMMERSIVES) {
                if (!ClientVRSubscriber.handleInfos(singleton, vrPlayer, c)) continue;
                return;
            }
            SwapTracker swapTracker = c == 0 ? SwapTracker.c0 : SwapTracker.c1;
            swapTracker.tick(null, null, -1, false);
        }
        if (cooldown <= 0) {
            for (AbstractPlayerAttachmentImmersive<? extends AbstractPlayerAttachmentInfo, ? extends NetworkStorage> singleton : Immersives.IMMERSIVE_ATTACHMENTS) {
                for (AbstractPlayerAttachmentInfo abstractPlayerAttachmentInfo : singleton.getTrackedObjects()) {
                    if (!ClientVRSubscriber.handleInfo(singleton, abstractPlayerAttachmentInfo, vrPlayer)) continue;
                    return;
                }
            }
        }
    }

    protected static <I extends ImmersiveInfo> boolean handleInfos(Immersive<I, ?> singleton, IVRPlayer vrPlayer, int c) {
        ImmersiveInfo infoWithDragHitbox = null;
        SwapTracker swapTracker = c == 0 ? SwapTracker.c0 : SwapTracker.c1;
        for (ImmersiveInfo info : singleton.getTrackedObjects()) {
            if (!info.hasHitboxes()) continue;
            IVRData controller = vrPlayer.getController(c);
            Vec3 pos = controller.position();
            Optional<Integer> hit = Util.getFirstIntersect(pos, info.getAllHitboxes());
            if (hit.isPresent() && (Minecraft.m_91087_().f_91066_.f_92096_.m_90857_() || !info.getAllHitboxes().get(hit.get()).isTriggerHitbox())) {
                if (singleton.isInputHitbox(info, hit.get())) {
                    swapTracker.tick(singleton, info, hit.get(), true);
                    return swapTracker.getCooldown() >= 0;
                }
                swapTracker.tick(singleton, info, -1, ClientVRSubscriber.inDragHitbox(singleton, info, pos));
                if (cooldown <= 0) {
                    int cooldown = singleton.handleHitboxInteract(info, Minecraft.m_91087_().f_91074_, List.of(hit.get()), InteractionHand.values()[c], Minecraft.m_91087_().f_91066_.f_92096_.m_90857_());
                    if (singleton.isVROnly()) {
                        cooldown = (int)((double)cooldown / 1.5);
                    }
                    ClientVRSubscriber.setCooldown(cooldown);
                }
                return cooldown >= 0;
            }
            if (!hit.isEmpty() || !ClientVRSubscriber.inDragHitbox(singleton, info, pos)) continue;
            infoWithDragHitbox = info;
        }
        if (infoWithDragHitbox != null) {
            swapTracker.tick(singleton, infoWithDragHitbox, -1, true);
        }
        return infoWithDragHitbox != null;
    }

    protected static boolean handleInfo(AbstractPlayerAttachmentImmersive<?, ?> singleton, AbstractPlayerAttachmentInfo info, IVRPlayer vrPlayer) {
        if (info.hasHitboxes() && singleton.hitboxesAvailable(info)) {
            for (int c = 0; c <= 1; ++c) {
                IVRData controller = vrPlayer.getController(c);
                Vec3 pos = controller.position();
                Optional<Integer> hit = Util.getFirstIntersect(pos, info.getAllHitboxes());
                if (!hit.isPresent()) continue;
                singleton.onAnyRightClick(info);
                singleton.handleRightClick(info, (Player)Minecraft.m_91087_().f_91074_, hit.get(), c == 0 ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
                cooldown = Minecraft.m_91087_().f_91066_.f_92096_.m_90857_() ? 20 : singleton.getCooldownVR();
                return true;
            }
        }
        return false;
    }

    private static <I extends ImmersiveInfo> boolean inDragHitbox(Immersive<I, ?> singleton, I info, Vec3 pos) {
        BoundingBox dragHitbox = singleton.getDragHitbox(info);
        return dragHitbox != null && Util.getFirstIntersect(pos, dragHitbox).isPresent();
    }
}

