/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive;

import com.hammy275.immersivemc.api.client.ImmersiveConfigScreenInfo;
import com.hammy275.immersivemc.api.client.immersive.BuiltImmersiveInfo;
import com.hammy275.immersivemc.api.client.immersive.ExtraRenderer;
import com.hammy275.immersivemc.api.client.immersive.HitboxInteractHandler;
import com.hammy275.immersivemc.api.client.immersive.HitboxPositioningMode;
import com.hammy275.immersivemc.api.client.immersive.ImmersiveBuilder;
import com.hammy275.immersivemc.api.client.immersive.RelativeHitboxInfo;
import com.hammy275.immersivemc.api.client.immersive.RelativeHitboxInfoBuilder;
import com.hammy275.immersivemc.api.common.immersive.ImmersiveHandler;
import com.hammy275.immersivemc.api.common.immersive.MultiblockImmersiveHandler;
import com.hammy275.immersivemc.api.common.immersive.NetworkStorage;
import com.hammy275.immersivemc.client.immersive.BuiltImmersiveImpl;
import com.hammy275.immersivemc.client.immersive.RelativeHitboxInfoImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ImmersiveBuilderImpl<E, S extends NetworkStorage>
implements ImmersiveBuilder<E, S> {
    ImmersiveHandler<S> handler;
    float renderSize = 0.33333334f;
    List<RelativeHitboxInfoImpl> hitboxes = new ArrayList<RelativeHitboxInfoImpl>();
    List<Vec3i> lightPositionOffsets = new ArrayList<Vec3i>();
    HitboxPositioningMode positioningMode = HitboxPositioningMode.HORIZONTAL_BLOCK_FACING;
    Function<BuiltImmersiveInfo<E>, Boolean> extraRenderReady = info -> true;
    HitboxInteractHandler<E> hitboxInteractHandler = (a, b, c, d, e) -> -1;
    boolean vrOnly = false;
    List<Vec3i> airCheckPositionOffsets = new ArrayList<Vec3i>();
    Class<E> extraInfoDataClazz;
    BiConsumer<S, BuiltImmersiveInfo<E>> extraStorageConsumer = null;
    BiFunction<BuiltImmersiveInfo<E>, Integer, Boolean> slotActive = null;
    Consumer<BuiltImmersiveInfo<E>> onRemove = info -> {};
    boolean blockRightClickWhenGUIClickDisabled = true;
    BiFunction<BuiltImmersiveInfo<E>, Integer, Boolean> slotRendersItemGuide = (info, slotNum) -> true;
    ImmersiveConfigScreenInfo configScreenInfo = null;
    ExtraRenderer<E> extraRenderer = (info, stack, helpers, partialTick, light) -> {};
    Function<BuiltImmersiveInfo<E>, AABB> dragHitboxCreator = null;

    public ImmersiveBuilderImpl(ImmersiveHandler<S> handler, @Nullable Class<E> extraInfoDataClazz) {
        this.handler = handler;
        this.extraInfoDataClazz = extraInfoDataClazz;
        if (handler instanceof MultiblockImmersiveHandler) {
            throw new IllegalArgumentException("Cannot create an ImmersiveBuilder with a MultiblockImmersiveHandler.");
        }
    }

    @Override
    public ImmersiveBuilderImpl<E, S> setRenderSize(float size) {
        this.renderSize = size;
        return this;
    }

    @Override
    public ImmersiveBuilderImpl<E, S> addHitbox(RelativeHitboxInfo relativeHitboxInfo) {
        this.hitboxes.add((RelativeHitboxInfoImpl)relativeHitboxInfo);
        return this;
    }

    @Override
    public ImmersiveBuilderImpl<E, S> add3x3Grid(RelativeHitboxInfo relativeHitboxInfo, double distBetweenBoxes) {
        Vec3 left = new Vec3(-1.0, 0.0, 0.0).m_82490_(distBetweenBoxes);
        Vec3 right = new Vec3(1.0, 0.0, 0.0).m_82490_(distBetweenBoxes);
        Vec3 up = new Vec3(0.0, 1.0, 0.0).m_82490_(distBetweenBoxes);
        Vec3 down = new Vec3(0.0, -1.0, 0.0).m_82490_(distBetweenBoxes);
        Vec3 offset = new Vec3(2.0E-4, 2.0E-4, 2.0E-4);
        this.addHitbox(relativeHitboxInfo.cloneWithAddedOffset(up.m_82549_(left).m_82549_(offset)));
        this.addHitbox(relativeHitboxInfo.cloneWithAddedOffset(up.m_82549_(offset.m_82490_(2.0))));
        this.addHitbox(relativeHitboxInfo.cloneWithAddedOffset(up.m_82549_(right).m_82549_(offset.m_82490_(3.0))));
        this.addHitbox(relativeHitboxInfo.cloneWithAddedOffset(left.m_82549_(offset.m_82490_(4.0))));
        this.addHitbox(relativeHitboxInfo.cloneWithAddedOffset(offset.m_82490_(5.0)));
        this.addHitbox(relativeHitboxInfo.cloneWithAddedOffset(right.m_82549_(offset.m_82490_(6.0))));
        this.addHitbox(relativeHitboxInfo.cloneWithAddedOffset(down.m_82549_(left).m_82549_(offset.m_82490_(7.0))));
        this.addHitbox(relativeHitboxInfo.cloneWithAddedOffset(down.m_82549_(offset.m_82490_(8.0))));
        this.addHitbox(relativeHitboxInfo.cloneWithAddedOffset(down.m_82549_(right).m_82549_(offset.m_82490_(9.0))));
        return this;
    }

    @Override
    public ImmersiveBuilderImpl<E, S> setPositioningMode(HitboxPositioningMode newMode) {
        this.positioningMode = newMode;
        return this;
    }

    @Override
    public ImmersiveBuilderImpl<E, S> setHitboxInteractHandler(HitboxInteractHandler<E> handler) {
        this.hitboxInteractHandler = handler;
        return this;
    }

    @Override
    public ImmersiveBuilderImpl<E, S> setVROnly(boolean vrOnly) {
        this.vrOnly = vrOnly;
        return this;
    }

    @Override
    public ImmersiveBuilderImpl<E, S> setExtraStorageConsumer(BiConsumer<S, BuiltImmersiveInfo<E>> storageConsumer) {
        this.extraStorageConsumer = storageConsumer;
        return this;
    }

    @Override
    public ImmersiveBuilderImpl<E, S> setSlotActiveFunction(BiFunction<BuiltImmersiveInfo<E>, Integer, Boolean> slotActive) {
        this.slotActive = slotActive;
        return this;
    }

    @Override
    public ImmersiveBuilderImpl<E, S> setOnRemove(Consumer<BuiltImmersiveInfo<E>> onRemove) {
        this.onRemove = onRemove;
        return this;
    }

    @Override
    public ImmersiveBuilderImpl<E, S> shouldDisableRightClicksWhenInteractionsDisabled(boolean doDisable) {
        this.blockRightClickWhenGUIClickDisabled = doDisable;
        return this;
    }

    @Override
    public ImmersiveBuilderImpl<E, S> setShouldRenderItemGuideFunction(BiFunction<BuiltImmersiveInfo<E>, Integer, Boolean> itemGuideActive) {
        this.slotRendersItemGuide = itemGuideActive;
        return this;
    }

    @Override
    public ImmersiveBuilder<E, S> setConfigScreenInfo(ImmersiveConfigScreenInfo info) {
        this.configScreenInfo = info;
        return this;
    }

    @Override
    public ImmersiveBuilder<E, S> setExtraRenderer(ExtraRenderer<E> renderer) {
        this.extraRenderer = renderer;
        return this;
    }

    @Override
    public ImmersiveBuilderImpl<E, S> overwriteHitbox(int index, RelativeHitboxInfo relativeHitboxInfo) {
        this.hitboxes.set(index, (RelativeHitboxInfoImpl)relativeHitboxInfo);
        return this;
    }

    @Override
    public ImmersiveBuilderImpl<E, S> modifyHitbox(int index, Function<RelativeHitboxInfoBuilder, RelativeHitboxInfo> modifier) {
        return this.modifyHitboxes(index, index, (Function)modifier);
    }

    @Override
    public ImmersiveBuilderImpl<E, S> modifyHitboxes(int startIndex, int endIndex, Function<RelativeHitboxInfoBuilder, RelativeHitboxInfo> modifier) {
        if (startIndex < 0 || endIndex < 0 || startIndex > endIndex || endIndex >= this.hitboxes.size()) {
            throw new IllegalArgumentException("Invalid starting and ending index. Keep them in range of the hitboxes, and make sure startIndex < endIndex.");
        }
        for (int i = startIndex; i <= endIndex; ++i) {
            this.overwriteHitbox(i, modifier.apply(this.hitboxes.get(i).getBuilderClone()));
        }
        return this;
    }

    @Override
    public ImmersiveBuilder<E, S> setDragHitboxCreator(@Nullable Function<BuiltImmersiveInfo<E>, AABB> dragHitboxCreator) {
        this.dragHitboxCreator = dragHitboxCreator;
        return this;
    }

    @Override
    public BuiltImmersiveImpl<E, S> build() {
        return new BuiltImmersiveImpl(this);
    }

    @Override
    public <T extends NetworkStorage> ImmersiveBuilderImpl<E, T> copy(ImmersiveHandler<T> newHandler) {
        ImmersiveBuilderImpl<E, T> clone = new ImmersiveBuilderImpl<E, T>(newHandler, this.extraInfoDataClazz);
        clone.renderSize = this.renderSize;
        clone.hitboxes = new ArrayList<RelativeHitboxInfoImpl>(this.hitboxes);
        clone.lightPositionOffsets = new ArrayList<Vec3i>(this.lightPositionOffsets);
        clone.positioningMode = this.positioningMode;
        clone.extraRenderReady = this.extraRenderReady;
        clone.hitboxInteractHandler = this.hitboxInteractHandler;
        clone.vrOnly = this.vrOnly;
        clone.airCheckPositionOffsets = new ArrayList<Vec3i>(this.airCheckPositionOffsets);
        clone.extraStorageConsumer = null;
        clone.slotActive = this.slotActive;
        clone.onRemove = this.onRemove;
        clone.blockRightClickWhenGUIClickDisabled = this.blockRightClickWhenGUIClickDisabled;
        clone.slotRendersItemGuide = this.slotRendersItemGuide;
        clone.configScreenInfo = null;
        clone.extraRenderer = this.extraRenderer;
        clone.dragHitboxCreator = this.dragHitboxCreator;
        return clone;
    }

    @Override
    public <F, T extends NetworkStorage> ImmersiveBuilderImpl<F, T> copy(ImmersiveHandler<T> newHandler, Class<F> newExtraInfoDataClass) {
        ImmersiveBuilderImpl<F, T> clone = new ImmersiveBuilderImpl<F, T>(newHandler, newExtraInfoDataClass);
        clone.renderSize = this.renderSize;
        clone.hitboxes = new ArrayList<RelativeHitboxInfoImpl>(this.hitboxes);
        clone.lightPositionOffsets = new ArrayList<Vec3i>(this.lightPositionOffsets);
        clone.positioningMode = this.positioningMode;
        clone.extraRenderReady = info -> true;
        clone.hitboxInteractHandler = (a, b, c, d, modifierPressed) -> -1;
        clone.vrOnly = this.vrOnly;
        clone.airCheckPositionOffsets = new ArrayList<Vec3i>(this.airCheckPositionOffsets);
        clone.extraStorageConsumer = null;
        clone.blockRightClickWhenGUIClickDisabled = this.blockRightClickWhenGUIClickDisabled;
        clone.configScreenInfo = null;
        return clone;
    }
}

