/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.config.screen;

import com.hammy275.immersivemc.Platform;
import com.hammy275.immersivemc.api.client.immersive.Immersive;
import com.hammy275.immersivemc.client.config.screen.ConfigScreen;
import com.hammy275.immersivemc.client.config.screen.ScreenUtils;
import com.hammy275.immersivemc.client.immersive.Immersives;
import com.hammy275.immersivemc.common.compat.apotheosis.Apoth;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.OptionsList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ImmersivesConfigScreen
extends Screen {
    protected final ScreenType type;
    protected final Screen lastScreen;
    protected OptionsList list;
    protected static int BUTTON_WIDTH = 128;
    protected static int BUTTON_HEIGHT = 20;

    public ImmersivesConfigScreen(Screen screen, ScreenType type) {
        super((Component)Component.m_237115_((String)"screen.immersivemc.immersives_config.title"));
        this.lastScreen = screen;
        this.type = type;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.list = new OptionsList(Minecraft.m_91087_(), this.f_96543_, this.f_96544_, 32, this.f_96544_ - 32, 24);
        this.initOptionsList();
        this.m_142416_((GuiEventListener)this.list);
        this.m_142416_((GuiEventListener)ScreenUtils.createDoneButton((this.f_96543_ - BUTTON_WIDTH) / 2, this.f_96544_ - 26, BUTTON_WIDTH, BUTTON_HEIGHT, this));
    }

    protected void initOptionsList() {
        ArrayList<OptionInstance<Boolean>> options = new ArrayList<OptionInstance<Boolean>>();
        if (this.type.isNonVR()) {
            if (Platform.isModLoaded("tconstruct")) {
                options.add(ScreenUtils.createOption("tinkers_construct_crafting_station", config -> config.useTinkersConstructCraftingStationImmersive, (config, newVal) -> {
                    config.useTinkersConstructCraftingStationImmersive = newVal;
                }));
            }
            if (Platform.isModLoaded("ironfurnaces")) {
                options.add(ScreenUtils.createOption("iron_furnaces_furnace", config -> config.useIronFurnacesFurnaceImmersive, (config, newVal) -> {
                    config.useIronFurnacesFurnaceImmersive = newVal;
                }));
            }
            if (Platform.isModLoaded("apotheosis") && Apoth.apothImpl.enchantModuleEnabled()) {
                options.add(ScreenUtils.createOption("enchanting_table_apoth", config -> config.useApotheosisEnchantmentTableImmersive, (config, newVal) -> {
                    config.useApotheosisEnchantmentTableImmersive = newVal;
                }));
                options.add(ScreenUtils.createOption("apoth_salvaging_table", config -> config.useApotheosisSalvagingTableImmersive, (config, newVal) -> {
                    config.useApotheosisSalvagingTableImmersive = newVal;
                }));
            }
        }
        if (this.type.isVR()) {
            options.add(ScreenUtils.createOption("animals", config -> config.useFeedingAnimalsImmersive, (config, newVal) -> {
                config.useFeedingAnimalsImmersive = newVal;
            }));
            options.add(ScreenUtils.createOption("armor", config -> config.useArmorImmersive, (config, newVal) -> {
                config.useArmorImmersive = newVal;
            }));
            options.add(ScreenUtils.createOption("backpack_button", config -> config.useBagImmersive, (config, newVal) -> {
                config.useBagImmersive = newVal;
            }));
            options.add(ScreenUtils.createOption("bottle_bucket", config -> config.useBucketAndBottleImmersive, (config, newVal) -> {
                config.useBucketAndBottleImmersive = newVal;
            }));
            options.add(ScreenUtils.createOption("button", config -> config.useButtonImmersive, (config, newVal) -> {
                config.useButtonImmersive = newVal;
            }));
            options.add(ScreenUtils.createOption("campfire", config -> config.useCampfireImmersive, (config, newVal) -> {
                config.useCampfireImmersive = newVal;
            }));
            options.add(ScreenUtils.createOption("cauldron", config -> config.useCauldronImmersive, (config, newVal) -> {
                config.useCauldronImmersive = newVal;
            }));
            options.add(ScreenUtils.createOption("door", config -> config.useDoorImmersive, (config, newVal) -> {
                config.useDoorImmersive = newVal;
            }));
            options.add(ScreenUtils.createOption("pet", config -> config.allowPetting, (config, newVal) -> {
                config.allowPetting = newVal;
            }));
            options.add(ScreenUtils.createOption("ranged_grab", config -> config.useRangedGrabImmersive, (config, newVal) -> {
                config.useRangedGrabImmersive = newVal;
            }));
            options.add(ScreenUtils.createOption("shield", config -> config.useShieldImmersive, (config, newVal) -> {
                config.useShieldImmersive = newVal;
            }));
            options.add(ScreenUtils.createOption("throw", config -> config.useThrowingImmersive, (config, newVal) -> {
                config.useThrowingImmersive = newVal;
            }));
            options.add(ScreenUtils.createOption("written_book", config -> config.useWrittenBookImmersive, (config, newVal) -> {
                config.useWrittenBookImmersive = newVal;
            }));
        }
        Immersives.IMMERSIVES.stream().filter(immersive -> this.type.isVR() || this.type.isNonVR() && !immersive.isVROnly()).map(Immersive::configScreenInfo).filter(Objects::nonNull).map(configInfo -> ScreenUtils.createOption(configInfo.getOptionTranslation(), configInfo.getOptionTooltip(), configInfo::isEnabled, configInfo::setEnabled)).forEach(options::add);
        options.stream().sorted(Comparator.comparing(OptionInstance::toString)).forEach(option -> this.list.m_232528_(option));
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        graphics.m_280137_(this.f_96547_, this.f_96539_.getString(), this.f_96543_ / 2, 8, 0xFFFFFF);
        MutableComponent mutableComponent = Component.m_237115_((String)"screen.immersivemc.immersives_config.subtitle");
        int n = this.f_96543_ / 2;
        Objects.requireNonNull(this.f_96547_);
        graphics.m_280653_(this.f_96547_, (Component)mutableComponent, n, 8 + 9, 0xFFFFFF);
    }

    public void m_7379_() {
        ConfigScreen.writeAdjustingConfig();
        Minecraft.m_91087_().m_91152_(this.lastScreen);
    }

    public static enum ScreenType {
        VR,
        NONVR,
        BOTH;


        public boolean isVR() {
            return this == VR || this == BOTH;
        }

        public boolean isNonVR() {
            return this == NONVR || this == BOTH;
        }
    }
}

