/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.config.screen;

import com.hammy275.immersivemc.api.client.immersive.Immersive;
import com.hammy275.immersivemc.api.client.immersive.ImmersiveInfo;
import com.hammy275.immersivemc.api.common.immersive.NetworkStorage;
import com.hammy275.immersivemc.client.config.screen.BackpackConfigScreen;
import com.hammy275.immersivemc.client.config.screen.ImmersivesConfigScreen;
import com.hammy275.immersivemc.client.config.screen.ImmersivesCustomizeScreen;
import com.hammy275.immersivemc.client.config.screen.ItemGuideCustomizeScreen;
import com.hammy275.immersivemc.client.config.screen.ScreenUtils;
import com.hammy275.immersivemc.client.immersive.AbstractPlayerAttachmentImmersive;
import com.hammy275.immersivemc.client.immersive.Immersives;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.config.ClientActiveConfig;
import com.hammy275.immersivemc.common.config.ConfigType;
import com.hammy275.immersivemc.common.network.Network;
import com.hammy275.immersivemc.common.network.packet.ConfigSyncPacket;
import com.hammy275.immersivemc.common.vr.VRPluginVerify;
import com.hammy275.immersivemc.server.immersive.TrackedImmersives;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class ConfigScreen
extends Screen {
    protected final Screen lastScreen;
    private static ConfigType currentConfigAdjusting = ConfigType.CLIENT;
    protected static int BUTTON_WIDTH = 200;
    protected static int BUTTON_HEIGHT = 20;
    protected static int BUTTON_SPACING = BUTTON_HEIGHT + BUTTON_HEIGHT / 5;
    protected static int BUTTON_START_HEIGHT = 24;
    protected static final String WIKI_URL = "https://hammy275.com/immersivemcwiki";

    public ConfigScreen(Screen screen) {
        super((Component)Component.m_237115_((String)"screen.immersivemc.config.title"));
        this.lastScreen = screen;
    }

    protected void m_7856_() {
        ActiveConfig.loadActive();
        super.m_7856_();
        if (currentConfigAdjusting == ConfigType.CLIENT) {
            this.m_142416_((GuiEventListener)ScreenUtils.createScreenButton((this.f_96543_ - BUTTON_WIDTH) / 2, BUTTON_START_HEIGHT, BUTTON_WIDTH, BUTTON_HEIGHT, "config.immersivemc.customize_item_guides", new ItemGuideCustomizeScreen(this)));
            this.m_142416_((GuiEventListener)ScreenUtils.createScreenButton((this.f_96543_ - BUTTON_WIDTH) / 2, BUTTON_START_HEIGHT + BUTTON_SPACING, BUTTON_WIDTH, BUTTON_HEIGHT, "config.immersivemc.backpack", new BackpackConfigScreen(this)));
        }
        this.m_142416_((GuiEventListener)ScreenUtils.createScreenButton((this.f_96543_ - BUTTON_WIDTH) / 2, BUTTON_START_HEIGHT + BUTTON_SPACING * 2, BUTTON_WIDTH, BUTTON_HEIGHT, "config.immersivemc.immersives_customize", new ImmersivesCustomizeScreen(this)));
        this.m_142416_((GuiEventListener)ScreenUtils.createScreenButton((this.f_96543_ - BUTTON_WIDTH) / 2, BUTTON_START_HEIGHT + BUTTON_SPACING * 3, BUTTON_WIDTH, BUTTON_HEIGHT, "config.immersivemc.immersives", new ImmersivesConfigScreen(this, VRPluginVerify.clientInVR() || currentConfigAdjusting == ConfigType.SERVER ? ImmersivesConfigScreen.ScreenType.BOTH : ImmersivesConfigScreen.ScreenType.NONVR)));
        this.m_142416_((GuiEventListener)ScreenUtils.createScreenButton((this.f_96543_ - BUTTON_WIDTH) / 2 - BUTTON_WIDTH / 2 - 8, this.f_96544_ - BUTTON_SPACING * 2, BUTTON_WIDTH, BUTTON_HEIGHT, "config.immersivemc.wiki_button", (Screen)new ConfirmLinkScreen(clickedYes -> {
            if (clickedYes) {
                Util.m_137581_().m_137646_(WIKI_URL);
            }
            Minecraft.m_91087_().m_91152_((Screen)this);
        }, (Component)Component.m_237115_((String)"config.immersivemc.open_wiki_message"), (Component)Component.m_237119_(), WIKI_URL, CommonComponents.f_130656_, true)));
        this.m_142416_((GuiEventListener)ScreenUtils.createDoneButton((this.f_96543_ - BUTTON_WIDTH) / 2, this.f_96544_ - BUTTON_SPACING, BUTTON_WIDTH, BUTTON_HEIGHT, this));
        this.m_142416_((GuiEventListener)ScreenUtils.createButton((this.f_96543_ - BUTTON_WIDTH) / 2 + BUTTON_WIDTH / 2 + 8, this.f_96544_ - BUTTON_SPACING * 2, BUTTON_WIDTH, BUTTON_HEIGHT, "config.immersivemc.reset", button -> {
            if (currentConfigAdjusting == ConfigType.CLIENT) {
                ActiveConfig.FILE_CLIENT = new ClientActiveConfig();
            } else {
                ActiveConfig.FILE_SERVER = new ActiveConfig();
            }
            ActiveConfig.loadActive();
            button.f_93623_ = false;
        }));
        String configTypeButtonTranslationKey = "config.immersivemc.edit_config_type.server";
        if (currentConfigAdjusting == ConfigType.CLIENT) {
            this.m_142416_((GuiEventListener)ScreenUtils.createOption("disable_outside_vr", config -> ((ClientActiveConfig)config).disableImmersiveMCOutsideVR, (config, newVal) -> {
                ((ClientActiveConfig)config).disableImmersiveMCOutsideVR = newVal;
            }).m_231507_(Minecraft.m_91087_().f_91066_, (this.f_96543_ - BUTTON_WIDTH) / 2, this.f_96544_ - BUTTON_SPACING * 4, BUTTON_WIDTH));
            configTypeButtonTranslationKey = "config.immersivemc.edit_config_type.client";
        }
        Button configTypeButton = ScreenUtils.createButton((this.f_96543_ - BUTTON_WIDTH) / 2, this.f_96544_ - BUTTON_SPACING * 3, BUTTON_WIDTH, BUTTON_HEIGHT, configTypeButtonTranslationKey, configTypeButtonTranslationKey + ".desc", button -> ConfigScreen.changeConfigAdjusting());
        configTypeButton.f_93623_ = Minecraft.m_91087_().f_91074_ == null || Minecraft.m_91087_().m_91091_();
        this.m_142416_((GuiEventListener)configTypeButton);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        graphics.m_280137_(this.f_96547_, this.f_96539_.getString(), this.f_96543_ / 2, 8, 0xFFFFFF);
    }

    public void m_7379_() {
        ConfigScreen.onClientConfigChange();
        Minecraft.m_91087_().m_91152_(this.lastScreen);
        currentConfigAdjusting = ConfigType.CLIENT;
    }

    public static void onClientConfigChange() {
        ConfigScreen.writeAdjustingConfig();
        for (Immersive<? extends ImmersiveInfo, ? extends NetworkStorage> immersive : Immersives.IMMERSIVES) {
            immersive.getTrackedObjects().clear();
        }
        for (AbstractPlayerAttachmentImmersive abstractPlayerAttachmentImmersive : Immersives.IMMERSIVE_ATTACHMENTS) {
            abstractPlayerAttachmentImmersive.clearImmersives();
        }
        if (currentConfigAdjusting == ConfigType.SERVER) {
            if (Minecraft.m_91087_().m_91091_()) {
                ActiveConfig.FROM_SERVER = (ActiveConfig)ActiveConfig.FILE_SERVER.clone();
                ActiveConfig.loadActive();
                ActiveConfig.registerPlayerConfig((Player)Minecraft.m_91087_().f_91074_, ActiveConfig.activeRaw());
                IntegratedServer server = Minecraft.m_91087_().m_91092_();
                if (server != null && server.m_6992_()) {
                    server.m_6846_().m_11314_().stream().filter(player -> !player.m_20148_().equals(Minecraft.m_91087_().f_91074_.m_20148_())).forEach(ConfigSyncPacket::syncConfigToPlayer);
                }
                TrackedImmersives.clearForPlayer(Minecraft.m_91087_().m_91092_().m_6846_().m_11259_(Minecraft.m_91087_().f_91074_.m_20148_()));
            }
        } else if (Minecraft.m_91087_().f_91073_ != null) {
            ActiveConfig.loadActive();
            Network.INSTANCE.sendToServer(new ConfigSyncPacket(ActiveConfig.FILE_CLIENT));
        }
    }

    private static void changeConfigAdjusting() {
        ConfigScreen.onClientConfigChange();
        currentConfigAdjusting = currentConfigAdjusting == ConfigType.CLIENT ? ConfigType.SERVER : ConfigType.CLIENT;
        Screen current = Minecraft.m_91087_().f_91080_;
        if (current instanceof ConfigScreen) {
            ConfigScreen cs = (ConfigScreen)current;
            Minecraft.m_91087_().m_91152_((Screen)new ConfigScreen(cs.lastScreen));
        }
    }

    public static ActiveConfig getAdjustingConfig() {
        return ActiveConfig.getFileConfig(currentConfigAdjusting);
    }

    public static ConfigType getAdjustingConfigType() {
        return currentConfigAdjusting;
    }

    public static ClientActiveConfig getClientConfigIfAdjusting() {
        if (currentConfigAdjusting == ConfigType.CLIENT) {
            return (ClientActiveConfig)ActiveConfig.getFileConfig(ConfigType.CLIENT);
        }
        throw new IllegalStateException("Not currently adjusting client config!");
    }

    public static boolean writeAdjustingConfig() {
        return ActiveConfig.getFileConfig(currentConfigAdjusting).writeConfigFile(currentConfigAdjusting);
    }
}

