/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.api_impl;

import com.hammy275.immersivemc.ImmersiveMCClient;
import com.hammy275.immersivemc.api.client.ImmersiveConfigScreenInfo;
import com.hammy275.immersivemc.api.client.ImmersiveMCClientRegistration;
import com.hammy275.immersivemc.api.client.immersive.Immersive;
import com.hammy275.immersivemc.api.common.ImmersiveMCRegistrationEvent;
import com.hammy275.immersivemc.client.api_impl.ImmersiveConfigScreenInfoImpl;
import com.hammy275.immersivemc.common.api_impl.ImmersiveMCRegistrationEventImpl;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ImmersiveMCClientRegistrationImpl
implements ImmersiveMCClientRegistration {
    public static final ImmersiveMCClientRegistration INSTANCE = new ImmersiveMCClientRegistrationImpl();
    private static final Set<Consumer<ImmersiveMCRegistrationEvent<Immersive<?, ?>>>> HANDLERS = new HashSet();
    private static boolean didRegistration = false;

    public static void doImmersiveRegistration(Consumer<Immersive<?, ?>> immersiveConsumer) {
        if (didRegistration) {
            throw new IllegalStateException("Already did Immersive registration!");
        }
        ImmersiveMCRegistrationEventImpl event = new ImmersiveMCRegistrationEventImpl(immersiveConsumer);
        for (Consumer<ImmersiveMCRegistrationEvent<Immersive<?, ?>>> handler : HANDLERS) {
            handler.accept(event);
        }
        ImmersiveMCClient.immersiveIMCRegistrationHandler.accept(event);
        didRegistration = true;
    }

    @Override
    public ImmersiveConfigScreenInfo createConfigScreenInfoOneItem(String modID, String optionTranslation, Supplier<ItemStack> optionItem, @Nullable Component optionTooltip, Supplier<Boolean> isEnabledSupplier, Consumer<Boolean> setEnabledConsumer) {
        return this.createConfigScreenInfoMultipleItems(modID, optionTranslation, () -> Set.of((ItemStack)optionItem.get()), optionTooltip, isEnabledSupplier, setEnabledConsumer);
    }

    @Override
    public ImmersiveConfigScreenInfo createConfigScreenInfoMultipleItems(String modID, String optionTranslation, Supplier<Set<ItemStack>> optionItem, @Nullable Component optionTooltip, Supplier<Boolean> isEnabledSupplier, Consumer<Boolean> setEnabledConsumer) {
        return new ImmersiveConfigScreenInfoImpl(modID, optionTranslation, optionItem, optionTooltip, isEnabledSupplier, setEnabledConsumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addImmersiveRegistrationHandler(Consumer<ImmersiveMCRegistrationEvent<Immersive<?, ?>>> registrationHandler) throws IllegalStateException {
        ImmersiveMCClientRegistrationImpl immersiveMCClientRegistrationImpl = this;
        synchronized (immersiveMCClientRegistrationImpl) {
            if (didRegistration) {
                throw new IllegalStateException("Can't add a registration handler for Immersives after Immersives have been registered.");
            }
            HANDLERS.add(registrationHandler);
        }
    }
}

