/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.walletslot;

import io.github.lightman314.lightmanscurrency.common.capability.wallet.IWalletHandler;
import io.github.lightman314.lightmanscurrency.common.capability.wallet.WalletCapability;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import io.github.lightman314.lightmanscurrency.network.packet.ServerToClientPacket;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SPacketSyncWallet
extends ServerToClientPacket {
    public static final CustomPacket.Handler<SPacketSyncWallet> HANDLER = new H();
    int entityID;
    ItemStack walletItem;
    boolean visible;

    public SPacketSyncWallet(int entityID, ItemStack wallet, boolean visible) {
        this.entityID = entityID;
        this.walletItem = wallet;
        this.visible = visible;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.entityID);
        buffer.writeItemStack(this.walletItem, false);
        buffer.writeBoolean(this.visible);
    }

    private static class H
    extends CustomPacket.Handler<SPacketSyncWallet> {
        private H() {
        }

        @Override
        public SPacketSyncWallet decode(FriendlyByteBuf buffer) {
            return new SPacketSyncWallet(buffer.readInt(), buffer.m_130267_(), buffer.readBoolean());
        }

        @Override
        protected void handle(SPacketSyncWallet message, Player player) {
            LivingEntity livingEntity;
            IWalletHandler walletHandler;
            Entity entity = player.m_9236_().m_6815_(message.entityID);
            if (entity instanceof LivingEntity && (walletHandler = WalletCapability.lazyGetWalletHandler((Entity)(livingEntity = (LivingEntity)entity))) != null) {
                walletHandler.syncWallet(message.walletItem);
                walletHandler.setVisible(message.visible);
                walletHandler.clean();
            }
        }
    }
}

