/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.jeiplugin;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.MintScreen;
import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.crafting.CoinMintRecipe;
import io.github.lightman314.lightmanscurrency.integration.jeiplugin.LCJeiPlugin;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class CoinMintCategory
implements IRecipeCategory<CoinMintRecipe> {
    private final IDrawableStatic background;
    private final IDrawable icon;
    private final LoadingCache<Integer, IDrawableAnimated> cachedArrows;

    public CoinMintCategory(final IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(MintScreen.GUI_TEXTURE, 47, 8, 98, 42);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.COIN_MINT.get()));
        this.cachedArrows = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(){

            @Nonnull
            public IDrawableAnimated load(@Nonnull Integer mintTime) {
                return guiHelper.drawableBuilder(MintScreen.GUI_TEXTURE, 176, 0, 22, 16).buildAnimated(mintTime.intValue(), IDrawableAnimated.StartDirection.LEFT, false);
            }
        });
    }

    protected IDrawableAnimated getArrow(CoinMintRecipe recipe) {
        int mintTime = recipe.getDuration();
        if (mintTime <= 0) {
            mintTime = 100;
        }
        return (IDrawableAnimated)this.cachedArrows.getUnchecked((Object)mintTime);
    }

    @Nonnull
    public RecipeType<CoinMintRecipe> getRecipeType() {
        return LCJeiPlugin.COIN_MINT_TYPE;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void draw(@Nonnull CoinMintRecipe recipe, @Nonnull IRecipeSlotsView recipeSlotsView, @Nonnull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw((Object)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        IDrawableAnimated arrow = this.getArrow(recipe);
        arrow.draw(guiGraphics, 33, 13);
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    @Nonnull
    public Component getTitle() {
        return LCText.GUI_COIN_MINT_TITLE.get(new Object[0]);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CoinMintRecipe recipe, @Nonnull IFocusGroup focus) {
        IRecipeSlotBuilder inputSlot = builder.addSlot(RecipeIngredientRole.INPUT, 9, 13);
        inputSlot.addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, (List)Lists.newArrayList((Object[])CoinMintCategory.SetStackCount(recipe.getIngredient().m_43908_(), recipe.ingredientCount)));
        IRecipeSlotBuilder outputSlot = builder.addSlot(RecipeIngredientRole.OUTPUT, 69, 13);
        outputSlot.addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)recipe.getOutputItem());
    }

    private static ItemStack[] SetStackCount(ItemStack[] results, int count) {
        for (ItemStack stack : results) {
            stack.m_41764_(count);
        }
        return results;
    }
}

