/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.impactor.money;

import io.github.lightman314.lightmanscurrency.api.money.types.IPlayerMoneyHandler;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyView;
import io.github.lightman314.lightmanscurrency.integration.impactor.LCImpactorCompat;
import io.github.lightman314.lightmanscurrency.integration.impactor.money.ImpactorMoneyValue;
import java.math.BigDecimal;
import javax.annotation.Nonnull;
import net.impactdev.impactor.api.economy.EconomyService;
import net.impactdev.impactor.api.economy.accounts.Account;
import net.impactdev.impactor.api.economy.currency.Currency;
import net.impactdev.impactor.api.economy.transactions.EconomyTransaction;
import net.impactdev.impactor.core.economy.EconomyConfig;
import net.minecraft.world.entity.player.Player;

public class ImpactorPlayerMoneyProvider
implements IPlayerMoneyHandler {
    private Player player;

    public ImpactorPlayerMoneyProvider(Player player) {
        this.player = player;
    }

    @Override
    public void updatePlayer(@Nonnull Player player) {
        this.player = player;
    }

    private static BigDecimal getMinBalance() {
        if (LCImpactorCompat.getConfigValue(EconomyConfig.APPLY_RESTRICTIONS).orElse(false).booleanValue()) {
            return LCImpactorCompat.getConfigValue(EconomyConfig.MIN_BALANCE).orElse(BigDecimal.ZERO);
        }
        return BigDecimal.valueOf(Double.NEGATIVE_INFINITY);
    }

    private static BigDecimal getMaxBalance() {
        if (LCImpactorCompat.getConfigValue(EconomyConfig.APPLY_RESTRICTIONS).orElse(false).booleanValue()) {
            return LCImpactorCompat.getConfigValue(EconomyConfig.MAX_BALANCE).orElse(BigDecimal.valueOf(Double.MAX_VALUE));
        }
        return BigDecimal.valueOf(Double.MAX_VALUE);
    }

    @Override
    @Nonnull
    public MoneyValue insertMoney(@Nonnull MoneyValue insertAmount, boolean simulation) {
        if (insertAmount instanceof ImpactorMoneyValue) {
            ImpactorMoneyValue value = (ImpactorMoneyValue)insertAmount;
            Account account = LCImpactorCompat.getPlayerAccount(this.player, value.getImpactorCurrency());
            if (account == null) {
                return insertAmount;
            }
            if (simulation) {
                BigDecimal totalCount = account.balance().add(value.getValue());
                BigDecimal maxBalance = ImpactorPlayerMoneyProvider.getMaxBalance();
                if (maxBalance.compareTo(totalCount) < 0) {
                    BigDecimal leftovers = totalCount.subtract(maxBalance);
                    return ImpactorMoneyValue.of(value.getImpactorCurrency(), leftovers);
                }
                return MoneyValue.empty();
            }
            BigDecimal amountToDeposit = value.getValue();
            BigDecimal maxBalance = ImpactorPlayerMoneyProvider.getMaxBalance();
            if (account.balance().add(amountToDeposit).compareTo(maxBalance) > 0 && (amountToDeposit = maxBalance.subtract(account.balance())).compareTo(BigDecimal.ZERO) <= 0) {
                return insertAmount;
            }
            EconomyTransaction result = account.deposit(amountToDeposit);
            if (result.successful()) {
                BigDecimal deposited = result.amount();
                BigDecimal didntFit = value.getValue().subtract(deposited);
                if (didntFit.compareTo(BigDecimal.ZERO) > 0) {
                    return ImpactorMoneyValue.of(value.getImpactorCurrency(), didntFit);
                }
                return MoneyValue.empty();
            }
        }
        return insertAmount;
    }

    @Override
    @Nonnull
    public MoneyValue extractMoney(@Nonnull MoneyValue extractAmount, boolean simulation) {
        if (extractAmount instanceof ImpactorMoneyValue) {
            EconomyTransaction transaction;
            ImpactorMoneyValue value = (ImpactorMoneyValue)extractAmount;
            Account account = LCImpactorCompat.getPlayerAccount(this.player, value.getImpactorCurrency());
            if (account == null) {
                return extractAmount;
            }
            if (simulation) {
                BigDecimal balance = account.balance().subtract(ImpactorPlayerMoneyProvider.getMinBalance());
                BigDecimal extraFunds = balance.subtract(value.getValue());
                if (extraFunds.compareTo(BigDecimal.ZERO) < 0) {
                    return ImpactorMoneyValue.of(value.getImpactorCurrency(), extraFunds.negate());
                }
                return MoneyValue.empty();
            }
            BigDecimal withdrawAmount = value.getValue();
            BigDecimal balance = account.balance().subtract(value.getValue());
            if (value.getValue().compareTo(balance) > 0) {
                withdrawAmount = balance;
            }
            if ((transaction = account.withdraw(withdrawAmount)).successful()) {
                BigDecimal amountTaken = transaction.amount();
                BigDecimal couldntTake = value.getValue().subtract(amountTaken);
                if (couldntTake.compareTo(BigDecimal.ZERO) > 0) {
                    return ImpactorMoneyValue.of(value.getImpactorCurrency(), couldntTake);
                }
                return MoneyValue.empty();
            }
        }
        return extractAmount;
    }

    @Override
    public boolean isMoneyTypeValid(@Nonnull MoneyValue value) {
        return value instanceof ImpactorMoneyValue;
    }

    @Override
    @Nonnull
    public MoneyView getStoredMoney() {
        MoneyView.Builder builder = MoneyView.builder();
        for (Currency currency : EconomyService.instance().currencies().registered()) {
            Account account = LCImpactorCompat.getPlayerAccount(this.player, currency);
            if (account.balance().compareTo(BigDecimal.ZERO) <= 0) continue;
            builder.add(ImpactorMoneyValue.of(currency, account.balance()));
        }
        return builder.build();
    }
}

