/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.create.pretty_settings;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.equipment.clipboard.ClipboardEntry;
import com.simibubi.create.content.equipment.clipboard.ClipboardOverrides;
import io.github.lightman314.lightmanscurrency.api.settings.pretty.PrettyTextData;
import io.github.lightman314.lightmanscurrency.api.settings.pretty.PrettyTextWriter;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ClipboardPrettyWriter
extends PrettyTextWriter {
    public static PrettyTextWriter INSTANCE = new ClipboardPrettyWriter();
    public static final int LINES_PER_PAGE = 15;

    private ClipboardPrettyWriter() {
    }

    @Override
    public boolean worksOnStack(ItemStack stack) {
        return stack.m_41720_() == AllBlocks.CLIPBOARD.m_5456_();
    }

    @Override
    public ItemStack writeLinesToStack(@Nullable Player player, ItemStack stack, PrettyTextData data) {
        ArrayList<ImmutableList> pages = new ArrayList<ImmutableList>();
        ArrayList<ClipboardEntry> currentPage = new ArrayList<ClipboardEntry>();
        for (Component line : data.lines()) {
            MutableComponent copy = line.m_6881_().m_130948_(Style.f_131099_);
            currentPage.add(new ClipboardEntry(false, copy));
            if (currentPage.size() < 15) continue;
            pages.add(ImmutableList.copyOf(currentPage));
            currentPage = new ArrayList();
        }
        if (!currentPage.isEmpty()) {
            pages.add(ImmutableList.copyOf(currentPage));
        }
        CompoundTag tag = stack.m_41784_();
        ClipboardEntry.saveAll(pages, (ItemStack)stack);
        tag.m_128379_("Readonly", true);
        tag.m_128405_("Type", ClipboardOverrides.ClipboardType.WRITTEN.ordinal());
        stack.m_41714_(data.machineName());
        return stack;
    }
}

