/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.computercraft.data;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaValues;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValueParser;
import io.github.lightman314.lightmanscurrency.integration.computercraft.data.LCLuaTable;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.Objects;
import net.minecraft.ResourceLocationException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class LCArgumentHelper {
    public static MoneyValue parseMoneyValue(IArguments args, int index, boolean allowEmpty) throws LuaException {
        if (Objects.equals(args.getType(index), "string")) {
            try {
                return MoneyValueParser.parse(new StringReader(args.getString(index)), allowEmpty);
            }
            catch (CommandSyntaxException ignored) {
                throw LuaValues.badArgumentOf((IArguments)args, (int)index, (String)"money_value");
            }
        }
        CompoundTag tag = LCLuaTable.toTag(args.getTable(index));
        MoneyValue result = MoneyValue.load(tag);
        if (result == null) {
            throw LuaValues.badArgumentOf((IArguments)args, (int)index, (String)"money_value");
        }
        return result;
    }

    public static <T extends Enum<T>> T parseEnum(IArguments args, int index, Class<T> clazz) throws LuaException {
        return (T)LuaValues.checkEnum((int)index, clazz, (String)args.getString(index));
    }

    public static ResourceLocation parseResourceLocation(IArguments args, int index) throws LuaException {
        try {
            return VersionUtil.parseResource(args.getString(index));
        }
        catch (ResourceLocationException e) {
            throw LuaValues.badArgumentOf((IArguments)args, (int)index, (String)"id");
        }
    }

    public static ItemStack parseItem(IArguments args, int index) throws LuaException {
        if (Objects.equals(args.getType(index), "string")) {
            ResourceLocation itemID = LCArgumentHelper.parseResourceLocation(args, index);
            if (ForgeRegistries.ITEMS.containsKey(itemID)) {
                return new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(itemID));
            }
            throw LuaValues.badArgumentOf((IArguments)args, (int)index, (String)"item");
        }
        CompoundTag tag = LCLuaTable.toTag(args.getTable(index));
        ItemStack item = ItemStack.m_41712_((CompoundTag)tag);
        if (item.m_41619_()) {
            throw LuaValues.badArgumentOf((IArguments)args, (int)index, (String)"item");
        }
        return item;
    }

    public static FluidStack parseFluid(IArguments args, int index) throws LuaException {
        if (Objects.equals(args.getType(index), "string")) {
            ResourceLocation fluidID = LCArgumentHelper.parseResourceLocation(args, index);
            if (ForgeRegistries.FLUIDS.containsKey(fluidID)) {
                return new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(fluidID), 1000);
            }
            throw LuaValues.badArgumentOf((IArguments)args, (int)index, (String)"fluid");
        }
        CompoundTag tag = LCLuaTable.toTag(args.getTable(index));
        FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)tag);
        if (fluid.isEmpty()) {
            throw LuaValues.badArgumentOf((IArguments)args, (int)index, (String)"fluid");
        }
        return fluid;
    }
}

