/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.computercraft;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public final class PeripheralMethod {
    private final String name;
    private final Supplier<Boolean> accessible;
    private final LuaBiFunction<IComputerAccess, IArguments, Object[]> method;

    public String getMethodName() {
        return this.name;
    }

    public boolean isAccessible() {
        return this.accessible.get();
    }

    private PeripheralMethod(String name, Supplier<Boolean> accessible, LuaBiFunction<IComputerAccess, IArguments, Object[]> method) {
        this.name = name;
        this.accessible = accessible;
        this.method = method;
    }

    public Object[] execute(IComputerAccess computer, IArguments args) throws LuaException {
        Object[] result = this.method.apply(computer, args);
        if (result != null) {
            return result;
        }
        return new Object[0];
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static interface LuaBiFunction<A, B, R> {
        @Nullable
        public R apply(A var1, B var2) throws LuaException;
    }

    public static class Builder {
        private final String name;
        private Supplier<Boolean> accessible = () -> true;
        private LuaBiFunction<IComputerAccess, IArguments, Object[]> method = null;

        private Builder(String name) {
            this.name = name;
        }

        public Builder withAccess(Supplier<Boolean> canAccess) {
            this.accessible = canAccess;
            return this;
        }

        private Builder noReturn(LuaBiConsumer<IComputerAccess, IArguments> method) {
            this.method = (comp, args) -> {
                method.accept((IComputerAccess)comp, (IArguments)args);
                return null;
            };
            return this;
        }

        private Builder singleReturn(LuaBiFunction<IComputerAccess, IArguments, Object> method) {
            this.method = (comp, args) -> new Object[]{method.apply((IComputerAccess)comp, (IArguments)args)};
            return this;
        }

        public Builder withContextArray(LuaBiFunction<IComputerAccess, IArguments, Object[]> method) {
            this.method = method;
            return this;
        }

        public Builder withContext(LuaBiFunction<IComputerAccess, IArguments, Object> method) {
            return this.singleReturn(method);
        }

        public Builder withContext(LuaBiConsumer<IComputerAccess, IArguments> method) {
            return this.noReturn(method);
        }

        public Builder withContextOnlyArray(LuaFunction<IComputerAccess, Object[]> method) {
            this.method = (comp, args) -> (Object[])method.apply((IComputerAccess)comp);
            return this;
        }

        public Builder withContextOnly(LuaFunction<IComputerAccess, Object> method) {
            return this.singleReturn((comp, args) -> method.apply((IComputerAccess)comp));
        }

        public Builder withContextOnly(LuaConsumer<IComputerAccess> method) {
            return this.noReturn((comp, args) -> method.accept((IComputerAccess)comp));
        }

        public Builder withArgsArray(LuaFunction<IArguments, Object[]> method) {
            this.method = (comp, args) -> (Object[])method.apply((IArguments)args);
            return this;
        }

        public Builder withArgs(LuaFunction<IArguments, Object> method) {
            return this.singleReturn((comp, args) -> method.apply((IArguments)args));
        }

        public Builder withArgs(LuaConsumer<IArguments> method) {
            return this.noReturn((comp, args) -> method.accept((IArguments)args));
        }

        public Builder simpleArray(LuaSupplier<Object[]> method) {
            this.method = (comp, args) -> (Object[])method.get();
            return this;
        }

        public Builder simple(LuaSupplier<Object> method) {
            return this.singleReturn((comp, args) -> method.get());
        }

        public Builder simple(LuaRunnable method) {
            return this.noReturn((comp, args) -> method.run());
        }

        public PeripheralMethod build() {
            return new PeripheralMethod(this.name, this.accessible, Objects.requireNonNull(this.method));
        }
    }

    public static final class Registration {
        private final Map<String, PeripheralMethod> methodMap = new HashMap<String, PeripheralMethod>();

        public List<PeripheralMethod> getResults() {
            return new ArrayList<PeripheralMethod>(this.methodMap.values());
        }

        public void register(PeripheralMethod method) {
            this.methodMap.put(method.getMethodName(), method);
        }

        public void register(Builder builder) {
            this.register(builder.build());
        }

        public void remove(String method) {
            this.methodMap.remove(method);
        }
    }

    public static interface LuaRunnable {
        public void run() throws LuaException;
    }

    public static interface LuaSupplier<R> {
        @Nullable
        public R get() throws LuaException;
    }

    public static interface LuaFunction<A, R> {
        @Nullable
        public R apply(A var1) throws LuaException;
    }

    public static interface LuaBiConsumer<A, B> {
        public void accept(A var1, B var2) throws LuaException;
    }

    public static interface LuaConsumer<A> {
        public void accept(A var1) throws LuaException;
    }
}

