/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.datagen.client.generators;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader.item_positions.RotationHandler;
import io.github.lightman314.lightmanscurrency.common.core.groups.RegistryObjectBiBundle;
import io.github.lightman314.lightmanscurrency.common.core.groups.RegistryObjectBundle;
import io.github.lightman314.lightmanscurrency.datagen.client.builders.ItemPositionBuilder;
import io.github.lightman314.lightmanscurrency.datagen.util.CustomPathProvider;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class ItemPositionProvider
implements DataProvider {
    public static final float MO = 1.0E-4f;
    protected final String name;
    protected final PackOutput output;
    final CustomPathProvider blockPathProvider;
    final CustomPathProvider positionPathProvider;
    Map<ResourceLocation, BlockData> blockValues = new HashMap<ResourceLocation, BlockData>();
    Map<ResourceLocation, ItemPositionBuilder> positionValues = new HashMap<ResourceLocation, ItemPositionBuilder>();

    protected ItemPositionProvider(PackOutput output, String modid) {
        this(output, modid, null);
    }

    protected ItemPositionProvider(PackOutput output, String modid, @Nullable String subPack) {
        this.blockPathProvider = new CustomPathProvider(output, PackOutput.Target.RESOURCE_PACK, "lightmanscurrency/item_position_blocks", subPack);
        this.positionPathProvider = new CustomPathProvider(output, PackOutput.Target.RESOURCE_PACK, "lightmanscurrency/item_position_data", subPack);
        this.output = output;
        this.name = subPack != null ? modid + " (" + subPack + ")" : modid;
        RotationHandler.setup();
    }

    protected abstract void addEntries();

    protected final void addDataWithBlocks(ResourceLocation id, ItemPositionBuilder data, Object ... blocks) {
        this.addDataWithBlocks(id, id, data, blocks);
    }

    protected final void addDataWithBlocks(ResourceLocation id, ResourceLocation target, ItemPositionBuilder data, Object ... blocks) {
        this.addData(id, data);
        this.addBlocks(id, target, blocks);
    }

    protected final void addData(ResourceLocation id, ItemPositionBuilder data) {
        if (this.positionValues.containsKey(id)) {
            throw new IllegalArgumentException("Data for '" + id + "' is already defined!");
        }
        this.positionValues.put(id, data);
    }

    protected final void addBlocks(ResourceLocation id, Object ... blocks) {
        this.addBlocks(id, id, blocks);
    }

    protected final void addBlocks(ResourceLocation id, ResourceLocation target, Object ... blocks) {
        for (Object obj : blocks) {
            Block block;
            List values;
            if (obj instanceof RegistryObjectBiBundle) {
                RegistryObjectBiBundle bundle = (RegistryObjectBiBundle)obj;
                values = bundle.getAllSorted();
                for (Object b : values) {
                    if (!(b instanceof Block)) continue;
                    block = (Block)b;
                    this.addBlock(id, target, block);
                }
                continue;
            }
            if (obj instanceof RegistryObjectBundle) {
                RegistryObjectBundle bundle = (RegistryObjectBundle)obj;
                values = bundle.getAllSorted();
                for (Object b : values) {
                    if (!(b instanceof Block)) continue;
                    block = (Block)b;
                    this.addBlock(id, target, block);
                }
                continue;
            }
            if (obj instanceof Supplier) {
                Supplier ro = (Supplier)obj;
                Iterator iterator = ro.get();
                if (!(iterator instanceof Block)) continue;
                Block block2 = (Block)iterator;
                this.addBlock(id, target, block2);
                continue;
            }
            if (obj instanceof TagKey) {
                TagKey tag = (TagKey)obj;
                if (!tag.m_207645_(Registries.f_256747_)) continue;
                this.addBlockTag(id, target, (TagKey<Block>)((TagKey)tag.m_207647_(Registries.f_256747_).orElse(null)));
                continue;
            }
            if (obj instanceof List) {
                List list = (List)obj;
                for (Object b : list) {
                    this.addBlocks(id, target, b);
                }
                continue;
            }
            if (!(obj instanceof ResourceLocation)) continue;
            ResourceLocation blockID = (ResourceLocation)obj;
            this.addBlocks(id, target, new Object[]{blockID});
        }
    }

    protected final void addBlock(ResourceLocation id, Block block) {
        this.addBlock(id, id, block);
    }

    protected final void addBlock(ResourceLocation id, ResourceLocation target, Block block) {
        this.addBlock(id, id, ForgeRegistries.BLOCKS.getKey((Object)block));
    }

    protected final void addBlock(ResourceLocation id, ResourceLocation blockID) {
        this.addBlock(id, id, blockID);
    }

    protected final void addBlock(ResourceLocation id, ResourceLocation target, ResourceLocation blockID) {
        BlockData data = this.blockValues.getOrDefault(id, new BlockData(target));
        if (blockID != null && !data.blocks.contains(blockID.toString())) {
            data.blocks.add(blockID.toString());
        }
        this.blockValues.put(id, data);
    }

    protected final void addBlockTag(ResourceLocation id, @Nullable TagKey<Block> blockTag) {
        this.addBlockTag(id, id, blockTag);
    }

    protected final void addBlockTag(ResourceLocation id, ResourceLocation target, @Nullable TagKey<Block> blockTag) {
        this.addBlockTag(id, target, blockTag != null ? blockTag.f_203868_() : null);
    }

    protected final void addBlockTag(ResourceLocation id, @Nullable ResourceLocation blockTag) {
        this.addBlockTag(id, id, blockTag);
    }

    protected final void addBlockTag(ResourceLocation id, ResourceLocation target, @Nullable ResourceLocation blockTag) {
        BlockData data = this.blockValues.getOrDefault(id, new BlockData(target));
        if (blockTag != null && !data.blocks.contains("#" + blockTag)) {
            data.blocks.add("#" + blockTag);
        }
        this.blockValues.put(id, data);
    }

    public CompletableFuture<Void> m_213708_(CachedOutput cache) {
        this.blockValues.clear();
        this.positionValues.clear();
        this.addEntries();
        ArrayList results = new ArrayList();
        this.positionValues.forEach((id, data) -> {
            JsonObject dataJson = data.write();
            Path path = this.positionPathProvider.json((ResourceLocation)id);
            if (path == null) {
                results.add(CompletableFuture.completedFuture(null));
            } else {
                results.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)dataJson, (Path)path));
            }
        });
        this.blockValues.forEach((id, blocks) -> {
            JsonObject blockJson = new JsonObject();
            JsonArray blockList = new JsonArray();
            blockJson.addProperty("target", blocks.target.toString());
            for (String block : blocks.blocks) {
                blockList.add(block);
            }
            blockJson.add("values", (JsonElement)blockList);
            Path path = this.blockPathProvider.json((ResourceLocation)id);
            if (path == null) {
                results.add(CompletableFuture.completedFuture(null));
            } else {
                results.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)blockJson, (Path)path));
            }
        });
        return CompletableFuture.allOf((CompletableFuture[])results.toArray(CompletableFuture[]::new));
    }

    public String m_6055_() {
        return "LightmansCurrency Item Positions: " + this.name;
    }

    private static class BlockData {
        public final ResourceLocation target;
        public final List<String> blocks = new ArrayList<String>();

        public BlockData(ResourceLocation target) {
            this.target = target;
        }
    }
}

