/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types;

import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationAPI;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationType;
import io.github.lightman314.lightmanscurrency.api.notifications.SingleLineNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.NullCategory;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraftforge.common.util.NonNullSupplier;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TextNotification
extends SingleLineNotification {
    public static final NotificationType<TextNotification> TYPE = new NotificationType(VersionUtil.lcResource("text"), TextNotification::new);
    private Component text = EasyText.literal("");
    private NotificationCategory category = NullCategory.INSTANCE;

    private TextNotification() {
    }

    public TextNotification(Component text) {
        this(text, NullCategory.INSTANCE);
    }

    public TextNotification(Component text, NotificationCategory category) {
        this.text = text;
        this.category = category;
    }

    public static NonNullSupplier<Notification> create(Component text) {
        return () -> new TextNotification(text);
    }

    public static NonNullSupplier<Notification> create(Component text, NotificationCategory category) {
        return () -> new TextNotification(text, category);
    }

    protected NotificationType<TextNotification> getType() {
        return TYPE;
    }

    @Override
    public NotificationCategory getCategory() {
        return this.category;
    }

    @Override
    public Component getMessage() {
        return this.text;
    }

    @Override
    protected void saveAdditional(CompoundTag compound) {
        compound.m_128359_("Text", Component.Serializer.m_130703_((Component)this.text));
        compound.m_128365_("Category", (Tag)this.category.save());
    }

    @Override
    protected void loadAdditional(CompoundTag compound) {
        if (compound.m_128425_("Text", 8)) {
            this.text = Component.Serializer.m_130701_((String)compound.m_128461_("Text"));
        }
        if (compound.m_128425_("Category", 10)) {
            this.category = NotificationAPI.getApi().LoadCategory(compound.m_128469_("Category"));
        }
    }

    @Override
    protected boolean canMerge(Notification other) {
        if (other instanceof TextNotification) {
            TextNotification otherText = (TextNotification)other;
            return otherText.text.equals(this.text) && otherText.category.matches(this.category);
        }
        return false;
    }
}

