/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.items;

import io.github.lightman314.lightmanscurrency.LCTags;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.client.renderer.LCItemRenderer;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.core.variants.Color;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.items.ItemHandlerHelper;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class GachaBallItem
extends Item {
    public static final int MAX_INCEPTION_LEVEL = 16;

    public GachaBallItem(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(LCItemRenderer.USE_LC_RENDERER);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack ball = player.m_21120_(hand);
        if (ball.m_41720_() instanceof GachaBallItem) {
            ItemStack contents = GachaBallItem.getContents(ball);
            ball.m_41774_(1);
            if (ball.m_41619_()) {
                return InteractionResultHolder.m_19090_((Object)contents);
            }
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)contents);
            return InteractionResultHolder.m_19090_((Object)ball);
        }
        return super.m_7203_(level, player, hand);
    }

    public static ItemStack createWithItem(ItemStack contents) {
        return GachaBallItem.createWithItem(contents, RandomSource.m_216327_());
    }

    public static ItemStack createWithItem(ItemStack contents, RandomSource random) {
        return GachaBallItem.createWithItemAndColor(contents, Color.getFromIndex(random.m_188503_(Color.values().length)));
    }

    public static ItemStack createWithItemAndColor(ItemStack contents, Color color) {
        return GachaBallItem.createWithItemAndColor(contents, color.hexColor);
    }

    public static ItemStack createWithItemAndColor(ItemStack contents, int color) {
        if (InventoryUtil.ItemHasTag(contents, LCTags.Items.GACHA_BLACKLIST) || GachaBallItem.inceptionLevel(contents) >= 16) {
            return contents.m_41777_();
        }
        ItemStack stack = new ItemStack((ItemLike)ModItems.GACHA_BALL.get());
        CompoundTag tag = stack.m_41784_();
        tag.m_128365_("GachaItem", (Tag)contents.m_41739_(new CompoundTag()));
        CompoundTag display = stack.m_41698_("display");
        display.m_128405_("color", color);
        return stack;
    }

    public static ItemStack makeEmptyCopy(ItemStack gachaBall) {
        CompoundTag tag = gachaBall.m_41737_("display");
        int color = tag != null && tag.m_128425_("color", 99) ? tag.m_128451_("color") : 0xFFFFFF;
        return GachaBallItem.createWithItemAndColor(ItemStack.f_41583_, color);
    }

    public static int inceptionLevel(ItemStack stack) {
        int count = 0;
        ItemStack queryStack = stack;
        while (queryStack.m_41720_() == ModItems.GACHA_BALL.get()) {
            queryStack = GachaBallItem.getContents(queryStack);
            ++count;
        }
        return count;
    }

    public static ItemStack getContents(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("GachaItem")) {
            return ItemStack.m_41712_((CompoundTag)tag.m_128469_("GachaItem"));
        }
        return ItemStack.f_41583_;
    }

    public boolean m_142095_() {
        return false;
    }

    public void m_7373_(ItemStack stack, @Nullable Level context, List<Component> tooltip, TooltipFlag flag) {
        if (flag.m_7050_()) {
            CompoundTag tag = stack.m_41783_();
            if (tag == null || !tag.m_128441_("GachaItem")) {
                return;
            }
            ItemStack contents = ItemStack.m_41712_((CompoundTag)tag.m_128469_("GachaItem"));
            if (contents.m_41619_()) {
                return;
            }
            tooltip.add((Component)LCText.TOOLTIP_TRADER_GACHA_CONTENTS.get(contents.m_41613_(), contents.m_41786_()).m_130940_(ChatFormatting.GRAY));
        }
        super.m_7373_(stack, context, tooltip, flag);
    }
}

