/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.data;

import io.github.lightman314.lightmanscurrency.LCRegistries;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.IClientTicker;
import io.github.lightman314.lightmanscurrency.api.misc.IEasyTickable;
import io.github.lightman314.lightmanscurrency.api.misc.data.CustomData;
import io.github.lightman314.lightmanscurrency.api.misc.data.CustomDataType;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientCustomDataCache {
    private static final Map<ResourceLocation, CustomData> clientDataCache = new HashMap<ResourceLocation, CustomData>();

    @Nullable
    public static <T extends CustomData> T getData(CustomDataType<T> type) {
        if (type.serverOnly) {
            return null;
        }
        ResourceLocation dataID = LCRegistries.CUSTOM_DATA.getKey(type);
        if (dataID == null) {
            LightmansCurrency.LogError("Custom Data was not registered!");
            return null;
        }
        if (!clientDataCache.containsKey(dataID)) {
            clientDataCache.put(dataID, ((CustomData)type.create()).initClient());
        }
        return (T)clientDataCache.get(dataID);
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        for (CustomData data : clientDataCache.values()) {
            Object ticker;
            if (data instanceof IEasyTickable) {
                ticker = (IEasyTickable)((Object)data);
                ticker.tick();
            }
            if (!(data instanceof IClientTicker)) continue;
            ticker = (IClientTicker)((Object)data);
            ticker.clientTick();
        }
    }

    @SubscribeEvent
    public static void onLeaveServer(ClientPlayerNetworkEvent.LoggingOut event) {
        clientDataCache.clear();
    }
}

