/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.crafting;

import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.core.variants.Color;
import io.github.lightman314.lightmanscurrency.common.crafting.RecipeTypes;
import io.github.lightman314.lightmanscurrency.common.crafting.durability.DurabilityData;
import io.github.lightman314.lightmanscurrency.common.crafting.input.TicketStationRecipeInput;
import io.github.lightman314.lightmanscurrency.common.items.TicketItem;
import io.github.lightman314.lightmanscurrency.util.ItemRequirement;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public interface TicketStationRecipe
extends Recipe<TicketStationRecipeInput> {
    public static final Predicate<String> CODE_PREDICATE = s -> {
        if (s.isBlank()) {
            return false;
        }
        if (s.length() > 16) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (TicketStationRecipe.validCodeChar(s.charAt(i))) continue;
            return false;
        }
        return true;
    };
    public static final Predicate<String> CODE_INPUT_PREDICATE = s -> s.isEmpty() || CODE_PREDICATE.test((String)s);

    public static boolean validCodeChar(char codeChar) {
        return codeChar >= 'a' && codeChar <= 'z' || codeChar >= 'A' && codeChar <= 'Z' || codeChar >= '0' && codeChar <= '9';
    }

    default public RecipeType<TicketStationRecipe> m_6671_() {
        return (RecipeType)RecipeTypes.TICKET.get();
    }

    default public ItemStack m_8042_() {
        return new ItemStack((ItemLike)ModBlocks.TICKET_STATION.get());
    }

    public static List<ItemStack> exampleModifierList(TagKey<Item> tag, Item ... extra) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (Item extraItem : extra) {
            result.add(new ItemStack((ItemLike)extraItem));
        }
        for (Item modifier : ForgeRegistries.ITEMS.tags().getTag(tag)) {
            result.add(new ItemStack((ItemLike)modifier));
        }
        return result;
    }

    public static List<ItemStack> exampleTicketList(RegistryObject<? extends ItemLike> item) {
        return TicketStationRecipe.exampleTicketList(((ItemLike)item.get()).m_5456_());
    }

    public static List<ItemStack> exampleTicketList(Ingredient ingredient) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (ItemStack item : ingredient.m_43908_()) {
            result.addAll(TicketStationRecipe.exampleTicketList(item.m_41720_()));
        }
        return result;
    }

    public static List<ItemStack> exampleTicketList(Item item) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (Color color : Color.values()) {
            result.add(TicketItem.CreateExampleTicket(item, color));
        }
        return result;
    }

    public boolean consumeModifier();

    public boolean validModifier(ItemStack var1);

    public List<ItemStack> jeiModifierList();

    public boolean validIngredient(ItemStack var1);

    public Ingredient getIngredient();

    public ItemStack peekAtResult(Container var1, ExtraData var2);

    public ItemStack exampleResult();

    default public boolean validData(ExtraData data) {
        return this.validCode(data.code) && this.validDurability(data.durability);
    }

    default public boolean requiredCodeInput() {
        return false;
    }

    default public boolean validCode(String code) {
        return !this.requiredCodeInput() || CODE_PREDICATE.test(code);
    }

    default public boolean requiredDurabilityInput() {
        return this.getDurabilityData().isValid();
    }

    default public boolean validDurability(int durability) {
        return this.getDurabilityData().test(durability);
    }

    default public DurabilityData getDurabilityData() {
        return DurabilityData.NULL;
    }

    default public int validateDurability(int value, boolean roundUp) {
        DurabilityData data = this.getDurabilityData();
        if (!data.isValid()) {
            return value;
        }
        if (value > data.max) {
            value = data.max;
        }
        if (value < data.min) {
            value = data.allowInfinite && !roundUp ? 0 : data.min;
        }
        return value;
    }

    default public boolean matches(TicketStationRecipeInput container, Level level) {
        return this.validModifier(container.m_8020_(0)) && this.validIngredient(container.m_8020_(1));
    }

    default public boolean matchesTicketKioskSellItem(ItemStack sellItem) {
        return !this.consumeModifier() && this.validModifier(sellItem);
    }

    default public boolean allowIgnoreKioskRecipe() {
        return false;
    }

    public ItemStack assembleWithKiosk(ItemStack var1, ExtraData var2);

    default public ItemRequirement getKioskStorageRequirement(ItemStack sellItem) {
        return ItemRequirement.of(this.getIngredient(), sellItem.m_41613_());
    }

    public record ExtraData(String code, int durability) {
        public static final ExtraData EMPTY = new ExtraData("", 0);
    }
}

