/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.capability.wallet;

import io.github.lightman314.lightmanscurrency.api.capability.money.CapabilityMoneyViewer;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyView;
import io.github.lightman314.lightmanscurrency.api.money.value.holder.IMoneyViewer;
import io.github.lightman314.lightmanscurrency.common.capability.CurrencyCapabilities;
import io.github.lightman314.lightmanscurrency.common.capability.wallet.IWalletHandler;
import io.github.lightman314.lightmanscurrency.common.capability.wallet.WalletHandler;
import io.github.lightman314.lightmanscurrency.common.menus.containers.SuppliedItemContainer;
import io.github.lightman314.lightmanscurrency.network.message.walletslot.CPacketCreativeWalletEdit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class WalletCapability {
    @Deprecated
    public static LazyOptional<IWalletHandler> getWalletHandler(@Nonnull Entity entity) {
        return entity.getCapability(CurrencyCapabilities.WALLET);
    }

    @Nullable
    public static IWalletHandler lazyGetWalletHandler(@Nonnull Entity entity) {
        LazyOptional optional = entity.getCapability(CurrencyCapabilities.WALLET);
        if (optional.isPresent()) {
            return (IWalletHandler)optional.orElseThrow(() -> new RuntimeException("Unexpected error occurred!"));
        }
        return null;
    }

    @Nonnull
    public static Container getWalletContainer(@Nonnull Entity entity) {
        return new SuppliedItemContainer(() -> {
            IWalletHandler handler = WalletCapability.lazyGetWalletHandler(entity);
            if (handler != null) {
                return new WalletInteractable(handler);
            }
            return null;
        });
    }

    @Nonnull
    public static MoneyView getWalletMoney(@Nonnull Entity entity) {
        IWalletHandler walletHandler = WalletCapability.lazyGetWalletHandler(entity);
        if (walletHandler != null) {
            ItemStack wallet = walletHandler.getWallet();
            IMoneyViewer moneyViewer = CapabilityMoneyViewer.getCapability(wallet);
            if (moneyViewer == null) {
                return MoneyView.empty();
            }
            return moneyViewer.getStoredMoney();
        }
        return MoneyView.builder().build();
    }

    public static ICapabilityProvider createProvider(Player playerEntity) {
        return new Provider(playerEntity);
    }

    private static class Provider
    implements ICapabilitySerializable<Tag> {
        final LazyOptional<IWalletHandler> optional;
        final IWalletHandler handler;

        Provider(Player playerEntity) {
            this.handler = new WalletHandler((LivingEntity)playerEntity);
            this.optional = LazyOptional.of(() -> this.handler);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nullable Capability<T> capability, Direction facing) {
            return CurrencyCapabilities.WALLET.orEmpty(capability, this.optional);
        }

        public Tag serializeNBT() {
            return this.handler.save();
        }

        public void deserializeNBT(Tag tag) {
            if (tag instanceof CompoundTag) {
                CompoundTag compound = (CompoundTag)tag;
                this.handler.load(compound);
            }
        }
    }

    private static class WalletInteractable
    implements SuppliedItemContainer.IItemInteractable {
        private final IWalletHandler walletHandler;

        WalletInteractable(@Nonnull IWalletHandler handler) {
            this.walletHandler = handler;
        }

        @Override
        @Nonnull
        public ItemStack getItem() {
            return this.walletHandler.getWallet();
        }

        @Override
        public void setItem(@Nonnull ItemStack item) {
            Player player;
            LivingEntity livingEntity;
            this.walletHandler.setWallet(item);
            if (this.walletHandler.entity().m_9236_().f_46443_ && (livingEntity = this.walletHandler.entity()) instanceof Player && (player = (Player)livingEntity).m_7500_()) {
                new CPacketCreativeWalletEdit(this.getItem().m_41777_()).send();
            }
        }
    }
}

