/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.scroll;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.FixedSizeSprite;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.FlexibleHeightSprite;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.SpriteSource;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.builtin.NormalSprite;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.builtin.VerticalSliceSprite;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IMouseListener;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IPreRender;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.IScrollable;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ScrollBarWidget
extends EasyWidget
implements IMouseListener,
IPreRender {
    public static final FlexibleHeightSprite BACKGROUND_SPRITE = new VerticalSliceSprite(SpriteSource.create(VersionUtil.lcResource("common/widgets/scrollbar_vert_background"), 8, 128), 8);
    public static final FixedSizeSprite KNOB_SPRITE = new NormalSprite(SpriteSource.create(VersionUtil.lcResource("common/widgets/scrollbar_vert_knob"), 8, 29));
    public static final FixedSizeSprite SMALL_KNOB_SPRITE = new NormalSprite(SpriteSource.create(VersionUtil.lcResource("common/widgets/scrollbar_vert_smallknob"), 8, 9));
    public static final int WIDTH = 8;
    private final IScrollable scrollable;
    private final FixedSizeSprite knobSprite;
    public boolean isDragging = false;

    private ScrollBarWidget(Builder builder) {
        super(builder);
        this.scrollable = builder.scrollable;
        this.knobSprite = builder.knobSprite;
    }

    @Deprecated
    public static <T extends EasyWidget> ScrollBarWidget createOnRight(T widget) {
        return ScrollBarWidget.builder().onRight(widget).build();
    }

    public boolean visible() {
        return this.f_93624_ && this.scrollable.getMaxScroll() > this.scrollable.getMinScroll();
    }

    @Override
    protected void renderTick() {
        if (!this.visible() && this.isDragging) {
            this.isDragging = false;
        }
    }

    @Override
    public void renderWidget(EasyGuiGraphics gui) {
        if (!this.visible()) {
            return;
        }
        gui.resetColor();
        BACKGROUND_SPRITE.render(gui, 0, 0, this.f_93619_);
        int knobPosition = this.isDragging ? MathUtil.clamp(gui.mousePos.y - this.m_252907_() - this.getKnobHeight() / 2, 0, this.f_93619_ - this.getKnobHeight()) : this.getNaturalKnobPosition();
        int knobOffset = (8 - this.knobSprite.getWidth()) / 2;
        this.knobSprite.render(gui, knobOffset, knobPosition);
    }

    @Override
    public void preRender(EasyGuiGraphics gui) {
        if (this.isDragging) {
            this.dragKnob(gui.mousePos.y);
        }
    }

    private int getKnobHeight() {
        return this.knobSprite.getHeight();
    }

    private int getNaturalKnobPosition() {
        int notches = this.scrollable.getMaxScroll() - this.scrollable.getMinScroll();
        if (notches <= 0) {
            return 0;
        }
        double spacing = (double)(this.f_93619_ - this.getKnobHeight()) / (double)notches;
        int scroll = this.scrollable.currentScroll() - this.scrollable.getMinScroll();
        return (int)Math.round((double)scroll * spacing);
    }

    protected void dragKnob(double mouseY) {
        if (!this.visible()) {
            this.isDragging = false;
            return;
        }
        int scroll = this.getScrollFromMouse(mouseY);
        if (this.scrollable.currentScroll() != scroll) {
            this.scrollable.setScroll(scroll);
        }
    }

    private int getScrollFromMouse(double mouseY) {
        if ((mouseY -= (double)this.getKnobHeight() / 2.0) <= (double)this.m_252907_()) {
            return this.scrollable.getMinScroll();
        }
        if (mouseY >= (double)(this.m_252907_() + this.f_93619_ - this.getKnobHeight())) {
            return this.scrollable.getMaxScroll();
        }
        int deltaScroll = this.scrollable.getMaxScroll() - this.scrollable.getMinScroll();
        if (deltaScroll <= 0) {
            return Integer.MIN_VALUE;
        }
        double sectionHeight = (double)(this.f_93619_ - this.getKnobHeight()) / (double)deltaScroll;
        double yPos = (double)this.m_252907_() - sectionHeight / 2.0;
        for (int i = this.scrollable.getMinScroll(); i <= this.scrollable.getMaxScroll(); ++i) {
            if (mouseY >= yPos && mouseY < yPos + sectionHeight) {
                return i;
            }
            yPos += sectionHeight;
        }
        LightmansCurrency.LogWarning("Error getting scroll from mouse position.");
        return this.scrollable.getMinScroll();
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int button) {
        this.isDragging = false;
        if (this.m_5953_(mouseX, mouseY) && this.visible() && button == 0) {
            this.isDragging = true;
            this.dragKnob(mouseY);
        }
        return false;
    }

    @Override
    public boolean onMouseReleased(double mouseX, double mouseY, int button) {
        if (this.isDragging && this.visible() && button == 0) {
            this.dragKnob(mouseY);
            this.isDragging = false;
        }
        return false;
    }

    public static Builder builder() {
        return new Builder();
    }

    @FieldsAreNonnullByDefault
    public static class Builder
    extends EasyWidget.EasyBuilder<Builder> {
        private FixedSizeSprite knobSprite = KNOB_SPRITE;
        private IScrollable scrollable = null;

        private Builder() {
            super(8, 20);
        }

        @Override
        protected Builder getSelf() {
            return this;
        }

        public Builder height(int height) {
            this.changeHeight(height);
            return this;
        }

        public <T extends EasyWidget> Builder onLeft(T widget) {
            return ((Builder)this.scrollable((IScrollable)((Object)widget)).position(widget.getPosition().offset(-8, 0))).height(widget.m_93694_());
        }

        public <T extends EasyWidget> Builder onRight(T widget) {
            return ((Builder)this.scrollable((IScrollable)((Object)widget)).position(widget.getPosition().offset(widget.m_5711_(), 0))).height(widget.m_93694_());
        }

        public Builder scrollable(IScrollable scrollable) {
            this.scrollable = scrollable;
            return this;
        }

        public Builder smallKnob() {
            return this.customKnob(SMALL_KNOB_SPRITE);
        }

        public Builder customKnob(FixedSizeSprite knobSprite) {
            this.knobSprite = knobSprite;
            return this;
        }

        public ScrollBarWidget build() {
            return new ScrollBarWidget(this);
        }
    }
}

