/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.easy;

import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidget;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.navigation.CommonInputs;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;

public abstract class EasyButton
extends EasyWidget {
    public static final Consumer<EasyButton> NULL_PRESS = button -> {};
    private final Consumer<EasyButton> press;
    @Nullable
    private final Consumer<EasyButton> altPress;

    protected EasyButton(@Nonnull EasyButtonBuilder<?> builder) {
        super(builder);
        this.press = builder.action;
        this.altPress = builder.altAction;
    }

    @Override
    protected boolean m_7972_(int button) {
        if (this.altPress != null) {
            return button == 0 || button == 1;
        }
        return button == 0;
    }

    @Override
    public void m_7435_(@Nonnull SoundManager manager) {
        EasyButton.playClick(manager);
    }

    public static void playClick(@Nonnull SoundManager manager) {
        manager.m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.m_7972_(button) && this.m_93680_(mouseX, mouseY)) {
            this.m_7435_(Minecraft.m_91087_().m_91106_());
            if (button == 0) {
                this.onPress();
            } else if (button == 1 && this.altPress != null) {
                this.altPress.accept(this);
            }
            return true;
        }
        return false;
    }

    public boolean m_7933_(int p_93374_, int p_93375_, int p_93376_) {
        if (this.f_93623_ && this.f_93624_) {
            if (CommonInputs.m_278691_((int)p_93374_)) {
                this.m_7435_(Minecraft.m_91087_().m_91106_());
                this.onPress();
                return true;
            }
            return false;
        }
        return false;
    }

    protected void onPress() {
        this.press.accept(this);
        this.m_93692_(false);
    }

    @MethodsReturnNonnullByDefault
    @FieldsAreNonnullByDefault
    public static abstract class EasyButtonBuilder<T extends EasyButtonBuilder<T>>
    extends EasyWidget.EasyBuilder<T> {
        private Consumer<EasyButton> action;
        @Nullable
        private Consumer<EasyButton> altAction;

        protected EasyButtonBuilder() {
            this.action = b -> {};
            this.altAction = null;
        }

        protected EasyButtonBuilder(int defaultWidth, int defaultHeight) {
            super(defaultWidth, defaultHeight);
            this.action = b -> {};
            this.altAction = null;
        }

        public final T pressAction(@Nonnull Consumer<EasyButton> action) {
            this.action = action;
            return (T)((EasyButtonBuilder)this.getSelf());
        }

        public final T pressAction(@Nonnull Runnable action) {
            return this.pressAction((EasyButton b) -> action.run());
        }

        public final T altPressAction(@Nonnull Consumer<EasyButton> action) {
            this.altAction = action;
            return (T)((EasyButtonBuilder)this.getSelf());
        }

        public final T altPressAction(@Nonnull Runnable action) {
            return this.altPressAction((EasyButton b) -> action.run());
        }

        @Override
        public final T copyFrom(@Nonnull EasyButtonBuilder<?> other) {
            ((EasyWidget.EasyBuilder)this).copyFrom((EasyWidget.EasyBuilder<?>)other);
            this.action = other.action;
            return (T)((EasyButtonBuilder)this.getSelf());
        }
    }

    @MethodsReturnNonnullByDefault
    public static abstract class EasySizableButtonBuilder<T extends EasySizableButtonBuilder<T>>
    extends EasyButtonBuilder<T> {
        protected EasySizableButtonBuilder() {
        }

        protected EasySizableButtonBuilder(int defaultWidth, int defaultHeight) {
            super(defaultWidth, defaultHeight);
        }

        public final T width(int width) {
            this.changeWidth(width);
            return (T)((EasySizableButtonBuilder)this.getSelf());
        }

        public final T height(int height) {
            this.changeHeight(height);
            return (T)((EasySizableButtonBuilder)this.getSelf());
        }

        public final T size(int width, int height) {
            this.changeSize(width, height);
            return (T)((EasySizableButtonBuilder)this.getSelf());
        }
    }
}

