/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.slot_machine;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.SpriteUtil;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconData;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconUtil;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageScreen;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollListener;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.PlainButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.IScrollable;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.slot_machine.SlotMachineEntryEditWidget;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.slot_machine.SlotMachineEntryTab;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineEntry;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineTraderData;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SlotMachineEntryClientTab
extends TraderStorageClientTab<SlotMachineEntryTab>
implements IScrollable {
    public static final int ENTRY_ROWS = 2;
    public static final int ENTRIES_PER_PAGE = 2;
    private int scroll = 0;
    private EasyButton buttonAddEntry;

    public SlotMachineEntryClientTab(Object screen, SlotMachineEntryTab commonTab) {
        super(screen, commonTab);
    }

    @Override
    public IconData getIcon() {
        return IconUtil.ICON_TRADER_ALT;
    }

    public MutableComponent getTooltip() {
        return LCText.TOOLTIP_TRADER_SLOT_MACHINE_EDIT_ENTRIES.get(new Object[0]);
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.addChild(((ScrollListener.Builder)((ScrollListener.Builder)ScrollListener.builder().position(screenArea.pos)).size(screenArea.width, 145)).listener(this).build());
        for (int i = 0; i < 2; ++i) {
            this.addChild(((SlotMachineEntryEditWidget.Builder)SlotMachineEntryEditWidget.builder().position(screenArea.pos.offset(19, 20 + i * 64))).tab(this).index(this.supplierForIndex(i)).build());
        }
        this.addChild(((ScrollBarWidget.Builder)ScrollBarWidget.builder().position(screenArea.pos.offset(185, 20))).height(128).scrollable(this).build());
        this.buttonAddEntry = this.addChild(((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().position(screenArea.pos.offset(screenArea.width - 14, 4))).pressAction(this::AddEntry)).sprite(SpriteUtil.BUTTON_SIGN_PLUS).build());
        this.tick();
    }

    @Nullable
    public SlotMachineEntry getEntry(int entryIndex) {
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof SlotMachineTraderData) {
            SlotMachineTraderData trader = (SlotMachineTraderData)traderData;
            List<SlotMachineEntry> entries = trader.getAllEntries();
            if (entryIndex < 0 || entryIndex >= entries.size()) {
                return null;
            }
            return entries.get(entryIndex);
        }
        return null;
    }

    private Supplier<Integer> supplierForIndex(int index) {
        return () -> this.scroll + index;
    }

    @Override
    public void tick() {
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof SlotMachineTraderData) {
            SlotMachineTraderData trader = (SlotMachineTraderData)traderData;
            trader.clearEntriesChangedCache();
        }
        this.validateScroll();
        this.buttonAddEntry.f_93624_ = ((ITraderStorageMenu)this.menu).hasPermission("editTrades");
    }

    @Override
    public void renderBG(EasyGuiGraphics gui) {
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof SlotMachineTraderData) {
            SlotMachineTraderData trader = (SlotMachineTraderData)traderData;
            MutableComponent info = trader.getTotalOdds() > 100.0 ? LCText.GUI_TRADER_SLOT_MACHINE_INVALID_ODDS.getWithStyle(ChatFormatting.RED) : LCText.GUI_TRADER_SLOT_MACHINE_FAIL_CHANCE.get(SlotMachineEntry.ODDS_FORMATTER.format(trader.getFailOdds()));
            TextRenderUtil.drawCenteredText(gui, (Component)info, ((ITraderStorageScreen)this.screen).getXSize() / 2, 6, 0x404040);
        }
    }

    @Override
    public boolean shouldRenderInventoryText() {
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof SlotMachineTraderData) {
            SlotMachineTraderData trader = (SlotMachineTraderData)traderData;
            return trader.getAllEntries().size() < 2;
        }
        return false;
    }

    private void AddEntry(EasyButton button) {
        ((SlotMachineEntryTab)this.commonTab).AddEntry();
    }

    @Override
    public int currentScroll() {
        return this.scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        this.scroll = MathUtil.clamp(newScroll, 0, this.getMaxScroll());
    }

    private int getEntryCount() {
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof SlotMachineTraderData) {
            SlotMachineTraderData trader = (SlotMachineTraderData)traderData;
            return trader.getAllEntries().size();
        }
        return 0;
    }

    @Override
    public int getMaxScroll() {
        return IScrollable.calculateMaxScroll(2, this.getEntryCount());
    }
}

