/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderinterface.item;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.SpriteUtil;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconData;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconUtil;
import io.github.lightman314.lightmanscurrency.api.misc.settings.client.widget.DirectionalSettingsWidget;
import io.github.lightman314.lightmanscurrency.api.misc.settings.directional.DirectionalSettingsState;
import io.github.lightman314.lightmanscurrency.api.trader_interface.blockentity.TraderInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.api.trader_interface.menu.TraderInterfaceClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.easy.EasyScreenHelper;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IEasyScreen;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IMouseListener;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderInterfaceScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollListener;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.PlainButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.IScrollable;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.blockentity.ItemTraderInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blockentity.handler.ItemInterfaceHandler;
import io.github.lightman314.lightmanscurrency.common.menus.TraderInterfaceMenu;
import io.github.lightman314.lightmanscurrency.common.menus.traderinterface.item.ItemStorageTab;
import io.github.lightman314.lightmanscurrency.common.traders.item.TraderItemStorage;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ItemStorageClientTab
extends TraderInterfaceClientTab<ItemStorageTab>
implements IScrollable,
IMouseListener {
    private static final int X_OFFSET = 13;
    private static final int Y_OFFSET = 17;
    private static final int COLUMNS = 8;
    private static final int ROWS = 2;
    private static final int WIDGET_OFFSET = 57;
    int scroll = 0;
    ScrollBarWidget scrollBar;

    public ItemStorageClientTab(Object screen, ItemStorageTab commonTab) {
        super(screen, commonTab);
    }

    @Override
    public IconData getIcon() {
        return IconUtil.ICON_STORAGE;
    }

    public MutableComponent getTooltip() {
        return LCText.TOOLTIP_INTERFACE_STORAGE.get(new Object[0]);
    }

    private ItemInterfaceHandler getItemData() {
        TraderInterfaceBlockEntity traderInterfaceBlockEntity = ((TraderInterfaceMenu)this.menu).getBE();
        if (traderInterfaceBlockEntity instanceof ItemTraderInterfaceBlockEntity) {
            ItemTraderInterfaceBlockEntity be = (ItemTraderInterfaceBlockEntity)traderInterfaceBlockEntity;
            return be.getItemHandler();
        }
        return null;
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.scrollBar = this.addChild(((ScrollBarWidget.Builder)ScrollBarWidget.builder().position(screenArea.pos.offset(157, 17))).height(36).scrollable(this).build());
        this.addChild(((ScrollListener.Builder)((ScrollListener.Builder)ScrollListener.builder().position(screenArea.pos)).size(screenArea.width, 118)).listener(this).build());
        this.addChild(((DirectionalSettingsWidget.Builder)DirectionalSettingsWidget.builder().position(screenArea.pos.offset(screenArea.width / 2, 66))).object(this::getItemData).handlers(this::ToggleSide).build());
        this.addChild(((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().position(screenArea.pos.offset(22, 115))).pressAction(() -> ((ItemStorageTab)this.commonTab).quickTransfer(0))).sprite(SpriteUtil.BUTTON_QUICK_INSERT).build());
        this.addChild(((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().position(screenArea.pos.offset(34, 115))).pressAction(() -> ((ItemStorageTab)this.commonTab).quickTransfer(1))).sprite(SpriteUtil.BUTTON_QUICK_EXTRACT).build());
    }

    @Override
    public void renderBG(EasyGuiGraphics gui) {
        TraderInterfaceBlockEntity traderInterfaceBlockEntity = ((TraderInterfaceMenu)this.menu).getBE();
        if (traderInterfaceBlockEntity instanceof ItemTraderInterfaceBlockEntity) {
            ItemTraderInterfaceBlockEntity be = (ItemTraderInterfaceBlockEntity)traderInterfaceBlockEntity;
            this.validateScroll();
            int index = this.scroll * 8;
            TraderItemStorage storage = be.getItemBuffer();
            int hoveredSlot = this.isMouseOverSlot(gui.mousePos) + this.scroll * 8;
            for (int y = 0; y < 2; ++y) {
                int n = 17 + y * 18;
                for (int x = 0; x < 8; ++x) {
                    int xPos = 13 + x * 18;
                    gui.resetColor();
                    SpriteUtil.EMPTY_SLOT_NORMAL.render(gui, xPos, n);
                    if (index < storage.getSlotCount()) {
                        gui.renderItem(storage.getContents().get(index), xPos + 1, n + 1, this.getCountText(storage.getContents().get(index)));
                    }
                    if (index == hoveredSlot) {
                        gui.renderSlotHighlight(xPos + 1, n + 1);
                    }
                    ++index;
                }
            }
            gui.resetColor();
            for (Slot slot : ((ItemStorageTab)this.commonTab).getSlots()) {
                gui.renderSlot((IEasyScreen)this.screen, slot);
            }
            TextRenderUtil.drawCenteredText(gui, (Component)LCText.GUI_SETTINGS_INPUT_SIDE.get(new Object[0]), ((TraderInterfaceScreen)this.screen).getXSize() / 2, 57, 0x404040);
        }
    }

    private String getCountText(ItemStack stack) {
        int count = stack.m_41613_();
        if (count <= 1) {
            return null;
        }
        if (count >= 1000) {
            Object countText = String.valueOf(count / 1000);
            if (count % 1000 / 100 > 0) {
                countText = (String)countText + "." + count % 1000 / 100;
            }
            return (String)countText + "k";
        }
        return String.valueOf(count);
    }

    @Override
    public void renderAfterWidgets(EasyGuiGraphics gui) {
        TraderItemStorage storage;
        int hoveredSlot;
        if (((TraderInterfaceMenu)this.menu).getBE() instanceof ItemTraderInterfaceBlockEntity && ((TraderInterfaceMenu)((TraderInterfaceScreen)this.screen).m_6262_()).m_142621_().m_41619_() && (hoveredSlot = this.isMouseOverSlot(gui.mousePos)) >= 0 && (hoveredSlot += this.scroll * 8) < (storage = ((ItemTraderInterfaceBlockEntity)((TraderInterfaceMenu)this.menu).getBE()).getItemBuffer()).getContents().size()) {
            ItemStack stack = storage.getContents().get(hoveredSlot);
            if (stack.m_41619_()) {
                return;
            }
            EasyScreenHelper.RenderItemTooltipWithCount(gui, stack, storage.getMaxAmount(), ChatFormatting.YELLOW);
        }
    }

    private int isMouseOverSlot(ScreenPosition mousePos) {
        int foundColumn = -1;
        int foundRow = -1;
        int leftEdge = ((TraderInterfaceScreen)this.screen).getGuiLeft() + 13;
        int topEdge = ((TraderInterfaceScreen)this.screen).getGuiTop() + 17;
        for (int x = 0; x < 8 && foundColumn < 0; ++x) {
            if (mousePos.x < leftEdge + x * 18 || mousePos.x >= leftEdge + x * 18 + 18) continue;
            foundColumn = x;
        }
        for (int y = 0; y < 2 && foundRow < 0; ++y) {
            if (mousePos.y < topEdge + y * 18 || mousePos.y >= topEdge + y * 18 + 18) continue;
            foundRow = y;
        }
        if (foundColumn < 0 || foundRow < 0) {
            return -1;
        }
        return foundRow * 8 + foundColumn;
    }

    private int totalStorageSlots() {
        if (((TraderInterfaceMenu)this.menu).getBE() instanceof ItemTraderInterfaceBlockEntity) {
            return ((ItemTraderInterfaceBlockEntity)((TraderInterfaceMenu)this.menu).getBE()).getItemBuffer().getContents().size();
        }
        return 0;
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int button) {
        int hoveredSlot;
        if (((TraderInterfaceMenu)this.menu).getBE() instanceof ItemTraderInterfaceBlockEntity && (hoveredSlot = this.isMouseOverSlot(ScreenPosition.of(mouseX, mouseY))) >= 0) {
            ((ItemStorageTab)this.commonTab).clickedOnSlot(hoveredSlot += this.scroll * 8, Screen.m_96638_(), button == 0);
            return true;
        }
        return false;
    }

    @Override
    public int currentScroll() {
        return this.scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        this.scroll = newScroll;
        this.validateScroll();
    }

    @Override
    public int getMaxScroll() {
        return Math.max((this.totalStorageSlots() - 1) / 8 - 2 + 1, 0);
    }

    private void ToggleSide(Direction side, boolean inverse) {
        ItemInterfaceHandler data = this.getItemData();
        if (data != null) {
            DirectionalSettingsState state = this.getItemData().getSidedState(side);
            state = inverse ? state.getPrevious(data) : state.getNext(data);
            ((ItemStorageTab)this.commonTab).toggleSide(side, state);
        }
    }

    @Override
    @Nullable
    public Pair<ItemStack, ScreenArea> getHoveredItem(ScreenPosition mousePos) {
        TraderInterfaceBlockEntity traderInterfaceBlockEntity = ((TraderInterfaceMenu)this.menu).getBE();
        if (traderInterfaceBlockEntity instanceof ItemTraderInterfaceBlockEntity) {
            ItemTraderInterfaceBlockEntity be = (ItemTraderInterfaceBlockEntity)traderInterfaceBlockEntity;
            int foundColumn = -1;
            int foundRow = -1;
            int leftEdge = ((TraderInterfaceScreen)this.screen).getGuiLeft() + 13;
            int topEdge = ((TraderInterfaceScreen)this.screen).getGuiTop() + 17;
            for (int x = 0; x < 8 && foundColumn < 0; ++x) {
                if (mousePos.x < leftEdge + x * 18 || mousePos.x >= leftEdge + x * 18 + 18) continue;
                foundColumn = x;
            }
            for (int y = 0; y < 2 && foundRow < 0; ++y) {
                if (mousePos.y < topEdge + y * 18 || mousePos.y >= topEdge + y * 18 + 18) continue;
                foundRow = y;
            }
            if (foundColumn < 0 || foundRow < 0) {
                return null;
            }
            int slot = foundRow * 8 + foundColumn + this.scroll * 8;
            ItemStack stack = be.getItemBuffer().getStackInSlot(slot);
            return Pair.of((Object)stack, (Object)ScreenArea.of(leftEdge + foundColumn * 18, topEdge + foundRow * 18, 18, 18));
        }
        return null;
    }
}

