/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm.salary;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconData;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconUtil;
import io.github.lightman314.lightmanscurrency.api.money.bank.IBankAccount;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.api.money.bank.salary.SalaryData;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.ATMScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm.salary.SalarySubTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm.salary.SalaryTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollListener;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.IScrollable;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SalaryListTab
extends SalarySubTab
implements IScrollable {
    public static final int ROWS = 5;
    private int scroll = 0;
    Component tooltip = null;

    public SalaryListTab(SalaryTab tab, ATMScreen screen) {
        super(tab, screen);
    }

    @Override
    public IconData getIcon() {
        return IconUtil.ICON_DISCOUNT_LIST;
    }

    @Override
    @Nullable
    public Component getTooltip() {
        return LCText.TOOLTIP_BANK_SALARY_LIST.get(new Object[0]);
    }

    @Override
    public int currentScroll() {
        return this.scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        this.scroll = Math.max(newScroll, 0);
    }

    @Override
    public int getMaxScroll() {
        return IScrollable.calculateMaxScroll(5, this.getVisibleData().size());
    }

    private List<SalaryData> getVisibleData() {
        ArrayList<SalaryData> result = new ArrayList<SalaryData>();
        BankReference br = this.menu.getBankAccountReference();
        if (br == null) {
            return result;
        }
        int accessLevel = br.salaryPermission(this.menu.player);
        if (accessLevel < 1) {
            return result;
        }
        IBankAccount account = br.get();
        if (account != null) {
            return account.getSalaries();
        }
        return new ArrayList<SalaryData>();
    }

    @Override
    protected void initialize(ScreenArea screenArea, boolean firstOpen) {
        for (int i = 0; i < 5; ++i) {
            int index = i;
            this.addChild(((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)EasyTextButton.builder().position(screenArea.pos.offset(screenArea.width - 55, 40 + 20 * i))).width(40)).text(this::getSelectionText).addon(EasyAddonHelper.activeCheck(() -> this.notSelected(index)))).addon(EasyAddonHelper.visibleCheck(() -> this.optionExists(index)))).pressAction(() -> this.selectSalary(index))).build());
        }
        this.addChild(((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)EasyTextButton.builder().position(screenArea.pos.offset(30, 15))).width(screenArea.width - 60)).text((Component)LCText.BUTTON_BANK_SALARY_LIST_CREATE.get(new Object[0])).pressAction(this::createNewSalary)).addon(EasyAddonHelper.visibleCheck(() -> this.parent.getSalaryAccess() >= 2))).build());
        this.addChild(((ScrollListener.Builder)((ScrollListener.Builder)ScrollListener.builder().listener(this).position(screenArea.pos.offset(15, 40))).size(screenArea.width - 30, 100)).build());
        this.addChild(((ScrollBarWidget.Builder)ScrollBarWidget.builder().position(screenArea.pos.offset(screenArea.width - 15, 40))).height(100).scrollable(this).build());
    }

    protected Component getSelectionText() {
        int level = this.parent.getSalaryAccess();
        return level >= 2 ? LCText.BUTTON_BANK_SALARY_LIST_EDIT.get(new Object[0]) : LCText.BUTTON_BANK_SALARY_LIST_VIEW.get(new Object[0]);
    }

    protected boolean optionExists(int localIndex) {
        return this.getLocalSalary(localIndex) != null;
    }

    protected boolean notSelected(int localIndex) {
        return this.parent.getSelectedSalary() != this.getLocalSalary(localIndex);
    }

    @Nullable
    protected SalaryData getLocalSalary(int localIndex) {
        int index = this.scroll + localIndex;
        List<SalaryData> options = this.getVisibleData();
        if (index < 0 || index >= options.size()) {
            return null;
        }
        return options.get(index);
    }

    @Override
    public void renderBG(EasyGuiGraphics gui) {
        SalaryData data;
        this.validateScroll();
        SalaryData selectedSalary = this.parent.getSelectedSalary();
        int availableWidth = this.screen.getXSize() - 70;
        this.tooltip = null;
        for (int i = 0; i < 5 && (data = this.getLocalSalary(i)) != null; ++i) {
            Component name = data.getName();
            if (gui.font.m_92852_((FormattedText)name) > availableWidth) {
                if (ScreenArea.of(this.screen.getCorner().offset(20, 40 + 20 * i), availableWidth, 20).isMouseInArea(gui.mousePos)) {
                    this.tooltip = name;
                }
                name = TextRenderUtil.fitString(name, availableWidth);
            }
            int color = data == this.parent.getSelectedSalary() ? 0x40FF40 : 0x404040;
            gui.drawString(name, 15, 50 + 20 * i, color);
        }
    }

    @Override
    public void renderAfterWidgets(EasyGuiGraphics gui) {
        if (this.tooltip != null) {
            gui.renderTooltip(this.tooltip);
        }
    }

    private void selectSalary(int localIndex) {
        List<SalaryData> allOptions = this.parent.getAllSalaryOptions();
        SalaryData entry = this.getLocalSalary(localIndex);
        if (entry == null) {
            return;
        }
        this.parent.setSelectedSalary(allOptions.indexOf(entry));
    }

    public void createNewSalary() {
        this.menu.SendMessage(this.builder().setFlag("CreateSalaryOption"));
    }
}

