/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.FixedSizeSprite;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.SpriteSource;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.SpriteUtil;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.builtin.NormalSprite;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.builtin.WidgetStateSprite;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconUtil;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.client.gui.easy.EasyMenuScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.PlainButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.AlertData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.util.LazyWidgetPositioner;
import io.github.lightman314.lightmanscurrency.client.util.ButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.menus.gacha_machine.GachaMachineMenu;
import io.github.lightman314.lightmanscurrency.common.traders.gacha.GachaTrader;
import io.github.lightman314.lightmanscurrency.network.message.trader.CPacketCollectCoins;
import io.github.lightman314.lightmanscurrency.network.message.trader.CPacketOpenNetworkTerminal;
import io.github.lightman314.lightmanscurrency.network.message.trader.CPacketOpenStorage;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class GachaMachineScreen
extends EasyMenuScreen<GachaMachineMenu> {
    public static final ResourceLocation GUI_TEXTURE = VersionUtil.lcResource("textures/gui/container/gacha_machine.png");
    public static final ResourceLocation OVERLAY_TEXTURE = VersionUtil.lcResource("textures/gui/container/gacha_machine_overlay.png");
    public static final int WIDTH = 176;
    public static final int HEIGHT = 222;
    public static final int ANIMATION_LENGTH = 20;
    public static final int REST_LENGTH = 8;
    public static final int BALL_SIZE = 9;
    public static final int BALL_RENDER_LEFT = 44;
    public static final int BALL_RENDER_BOTTOM = 59;
    public static final int BALL_RENDER_COUNT_X = 9;
    public static final int BALL_RENDER_COUNT_Y = 7;
    public static final ScreenPosition REWARD_END_POSITION = ScreenPosition.of(80, 87);
    public static final ScreenPosition KNOB_POSITION = ScreenPosition.of(81, 73);
    public static final int KNOB_SIZE = 14;
    public static final FixedSizeSprite SPRITE_INTERACT = WidgetStateSprite.lazyHoverable(new NormalSprite(new SpriteSource(GUI_TEXTURE, 204, 0, 18, 18)), new NormalSprite(new SpriteSource(GUI_TEXTURE, 204, 18, 18, 18)));
    private int animationTick = 0;
    private int restTick = 0;
    private int tradeMultiplier = 1;
    EasyButton buttonInteract;
    IconButton buttonOpenStorage;
    IconButton buttonCollectCoins;
    IconButton buttonOpenTerminal;
    public final LazyWidgetPositioner rightEdgePositioner = LazyWidgetPositioner.create(this, LazyWidgetPositioner.createTopdown(), 176, 0, 20);
    private static final ScreenPosition INFO_WIDGET_POSITION = ScreenPosition.of(160, 126);
    private static final ScreenArea GACHA_INFO_AREA = ScreenArea.of(160, 9, 11, 11);

    public int getMachineColor() {
        GachaTrader trader = ((GachaMachineMenu)this.f_97732_).getTrader();
        return trader == null ? 0xFFFFFF : trader.getColor();
    }

    public GachaMachineScreen(GachaMachineMenu menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
        this.resize(176, 222);
    }

    @Override
    protected void initialize(ScreenArea screenArea) {
        this.addChild(this.rightEdgePositioner);
        this.buttonOpenStorage = this.addChild(((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)IconButton.builder().pressAction(this::OpenStorage)).icon(IconUtil.ICON_STORAGE).addon(EasyAddonHelper.visibleCheck(() -> ((GachaMachineMenu)this.f_97732_).getTrader() != null && ((GachaMachineMenu)this.f_97732_).getTrader().hasPermission(((GachaMachineMenu)this.f_97732_).player, "openStorage")))).addon(EasyAddonHelper.tooltip(LCText.TOOLTIP_TRADER_OPEN_STORAGE))).build());
        this.buttonCollectCoins = this.addChild(ButtonUtil.finishCollectCoinButton((IconButton.Builder)IconButton.builder().pressAction(this::CollectCoins), ((GachaMachineMenu)this.f_97732_).player, ((GachaMachineMenu)this.f_97732_)::getTrader));
        this.buttonOpenTerminal = this.addChild(((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)IconButton.builder().pressAction(this::OpenTerminal)).icon(IconUtil.ICON_BACK).addon(EasyAddonHelper.visibleCheck(this::showTerminalButton))).addon(EasyAddonHelper.tooltip(LCText.TOOLTIP_TRADER_NETWORK_BACK))).build());
        this.rightEdgePositioner.clear();
        this.rightEdgePositioner.addWidgets(this.buttonOpenTerminal, this.buttonOpenStorage, this.buttonCollectCoins);
        this.addChild(this.rightEdgePositioner);
        this.buttonInteract = this.addChild(((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().position(screenArea.pos.offset(7, 107))).pressAction(this::ExecuteTrades)).sprite(SPRITE_INTERACT).addon(EasyAddonHelper.tooltips(this::getInteractionTooltip))).addon(EasyAddonHelper.activeCheck(this::allowInteraction))).build());
        this.addChild(((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().position(screenArea.pos.offset(29, 105))).pressAction(this::increaseTradeMult)).sprite(SpriteUtil.BUTTON_SIGN_PLUS).addon(EasyAddonHelper.activeCheck(this::canIncreaseTradeMult))).build());
        this.addChild(((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().position(screenArea.pos.offset(29, 115))).pressAction(this::decreaseTradeMult)).sprite(SpriteUtil.BUTTON_SIGN_MINUS).addon(EasyAddonHelper.activeCheck(this::canDecreaseTradeMult))).build());
    }

    @Override
    protected void renderBG(@Nonnull EasyGuiGraphics gui) {
        gui.resetColor();
        gui.renderNormalBackground(GUI_TEXTURE, this);
        gui.blit(TraderScreen.GUI_TEXTURE, INFO_WIDGET_POSITION, 244, 0, 10, 10);
        SpriteUtil.GENERIC_INFO.render(gui, GachaMachineScreen.GACHA_INFO_AREA.pos);
        gui.drawString(this.f_169604_, 8, this.getYSize() - 94, 0x404040);
        Component valueText = ((GachaMachineMenu)this.f_97732_).getContext(null).getAvailableFunds().getRandomValueLine();
        gui.drawString(valueText, 160 - gui.font.m_92852_((FormattedText)valueText), this.getYSize() - 94, 0x404040);
        GachaTrader trader = ((GachaMachineMenu)this.f_97732_).getTrader();
        if (trader != null) {
            RandomSource random = RandomSource.m_216335_((long)Objects.hash(trader.getWorldPosition(), trader.getID()));
            List<ItemStack> contents = trader.getStorage().getRandomizedContents();
            gui.enableScissor(50, 9, 76, 63);
            for (int y = 0; y < 7 && !contents.isEmpty(); ++y) {
                int xOffset = 0;
                if (contents.size() < 9) {
                    xOffset = Math.round((float)(9 - contents.size()) * 9.0f / 2.0f);
                }
                for (int x = 0; x < 9 && !contents.isEmpty(); ++x) {
                    gui.renderItem(contents.remove(0), 44 + xOffset + x * 9, 59 - y * 9, "");
                }
            }
            gui.disableScissor();
            if (((GachaMachineMenu)this.f_97732_).hasPendingReward() && this.animationTick >= 12 && this.animationTick < 20) {
                int distance = (20 - this.animationTick - 1) * 2;
                if (gui.partialTicks >= 0.5f) {
                    --distance;
                }
                gui.enableScissor(80, 87, 16, 16);
                gui.renderItem(((GachaMachineMenu)this.f_97732_).getNextReward(), REWARD_END_POSITION.offset(0, distance * -1));
                gui.disableScissor();
            }
        }
        gui.drawString((Component)LCText.GUI_GACHA_MACHINE_TRADE_MULTIPLIER.get(this.tradeMultiplier), 40, 113, 0x404040);
        int machineColor = this.getMachineColor();
        gui.renderNormalBackground(OVERLAY_TEXTURE, this, machineColor);
        ScreenPosition knobUV = this.getKnobUV(this.animationTick, gui.partialTicks);
        gui.blit(GUI_TEXTURE, KNOB_POSITION, knobUV.x, knobUV.y, 14, 14);
        gui.setColor(machineColor, 1.0f);
        gui.blit(OVERLAY_TEXTURE, KNOB_POSITION, knobUV.x, knobUV.y, 14, 14);
        gui.resetColor();
    }

    @Override
    protected void renderAfterWidgets(@Nonnull EasyGuiGraphics gui) {
        if (INFO_WIDGET_POSITION.offset(this).isMouseInArea(gui.mousePos, 10, 10)) {
            gui.renderComponentTooltip(((GachaMachineMenu)this.f_97732_).getContext().getAvailableFundsDescription());
        }
        if (GACHA_INFO_AREA.offsetPosition(this.getCorner()).isMouseInArea(gui.mousePos)) {
            gui.renderComponentTooltip(this.getGachaInfoTooltip());
        }
    }

    private ScreenPosition getKnobUV(int animationTick, float partialTick) {
        int u = 176;
        int frame = animationTick * 2 - 1;
        if (partialTick >= 0.5f) {
            ++frame;
        }
        if (animationTick >= 20) {
            frame = 0;
        } else if (frame >= 20) {
            frame -= 20;
        }
        if (frame >= 10) {
            u += 14;
            frame -= 10;
        }
        return ScreenPosition.of(u, 14 * MathUtil.clamp(frame, 0, 9));
    }

    @Override
    protected void screenTick() {
        if (((GachaMachineMenu)this.f_97732_).hasPendingReward() && this.animationTick == 0) {
            ++this.animationTick;
        } else if (this.animationTick > 0) {
            if (this.animationTick >= 20) {
                ++this.restTick;
                if (this.restTick >= 8) {
                    this.animationTick = 0;
                    this.restTick = 0;
                    if (!((GachaMachineMenu)this.f_97732_).hasPendingReward()) {
                        ((GachaMachineMenu)this.f_97732_).SendMessageToServer(this.builder().setFlag("AnimationsCompleted"));
                    }
                }
            } else {
                ++this.animationTick;
                if (this.animationTick >= 20) {
                    ((GachaMachineMenu)this.f_97732_).getAndRemoveNextReward();
                    ((GachaMachineMenu)this.f_97732_).SendMessageToServer(this.builder().setFlag("GiveNextReward"));
                    this.playDing();
                }
            }
        }
    }

    private boolean canIncreaseTradeMult() {
        return this.tradeMultiplier < 10;
    }

    private void increaseTradeMult() {
        if (this.tradeMultiplier <= 1) {
            this.tradeMultiplier = 5;
        } else if (this.tradeMultiplier <= 5) {
            this.tradeMultiplier = 10;
        }
    }

    private boolean canDecreaseTradeMult() {
        return this.tradeMultiplier > 1;
    }

    private void decreaseTradeMult() {
        if (this.tradeMultiplier >= 10) {
            this.tradeMultiplier = 5;
        } else if (this.tradeMultiplier >= 5) {
            this.tradeMultiplier = 1;
        }
    }

    private boolean allowInteraction() {
        GachaTrader trader = ((GachaMachineMenu)this.f_97732_).getTrader();
        if (trader != null) {
            TradeEvent.PreTradeEvent event = trader.runPreTradeEvent(trader.getTrade(0), ((GachaMachineMenu)this.f_97732_).getContext());
            return !((GachaMachineMenu)this.f_97732_).hasPendingReward() && !trader.getStorage().isEmpty() && trader.getPrice().isValidPrice() && !event.isCanceled();
        }
        return false;
    }

    private boolean showTerminalButton() {
        if (((GachaMachineMenu)this.f_97732_).getTrader() != null) {
            return ((GachaMachineMenu)this.f_97732_).getTrader().showOnTerminal();
        }
        return false;
    }

    private void ExecuteTrades() {
        ((GachaMachineMenu)this.f_97732_).SendMessageToServer(this.builder().setInt("ExecuteTrade", this.tradeMultiplier));
    }

    private void OpenStorage(EasyButton button) {
        if (((GachaMachineMenu)this.f_97732_).getTrader() != null) {
            new CPacketOpenStorage(((GachaMachineMenu)this.f_97732_).getTrader().getID()).send();
        }
    }

    private void CollectCoins(EasyButton button) {
        if (((GachaMachineMenu)this.f_97732_).getTrader() != null) {
            CPacketCollectCoins.sendToServer();
        }
    }

    private void OpenTerminal(EasyButton button) {
        if (this.showTerminalButton()) {
            new CPacketOpenNetworkTerminal().send();
        }
    }

    private List<Component> getInteractionTooltip() {
        GachaTrader trader = ((GachaMachineMenu)this.f_97732_).getTrader();
        if (trader != null) {
            MoneyValue normalCost = trader.getPrice();
            MoneyValue currentCost = trader.runTradeCostEvent(trader.getTrade(0), ((GachaMachineMenu)this.f_97732_).getContext()).getCostResult();
            MutableComponent costText = currentCost.isFree() ? LCText.TOOLTIP_SLOT_MACHINE_COST_FREE.get(new Object[0]) : currentCost.getText();
            List<Component> result = this.tradeMultiplier == 1 ? LCText.TOOLTIP_GACHA_MACHINE_ROLL_ONCE.get(this.tradeMultiplier, costText) : LCText.TOOLTIP_GACHA_MACHINE_ROLL_MULTI.get(this.tradeMultiplier, costText);
            if (!currentCost.equals(normalCost) && this.tradeMultiplier > 1) {
                result.add((Component)LCText.TOOLTIP_GACHA_MACHINE_NORMAL_COST.get(normalCost.isFree() ? LCText.TOOLTIP_GACHA_MACHINE_COST_FREE.get(new Object[0]) : normalCost.getText()));
            }
            TradeEvent.PreTradeEvent event = trader.runPreTradeEvent(trader.getTrade(0), ((GachaMachineMenu)this.f_97732_).getContext());
            for (AlertData alert : event.getAlertInfo()) {
                result.add((Component)alert.getFormattedMessage());
            }
            return result;
        }
        return ImmutableList.of();
    }

    private List<Component> getGachaInfoTooltip() {
        ArrayList<Component> list = new ArrayList<Component>();
        GachaTrader trader = ((GachaMachineMenu)this.f_97732_).getTrader();
        if (trader == null || !trader.getPrice().isValidPrice()) {
            list.add((Component)LCText.TOOLTIP_GACHA_MACHINE_UNDEFINED.get(new Object[0]));
            return list;
        }
        if (trader.getStorage().isEmpty()) {
            list.add((Component)LCText.TOOLTIP_GACHA_MACHINE_EMPTY.get(new Object[0]));
            return list;
        }
        list.add((Component)LCText.TOOLTIP_TRADER_GACHA_CONTENTS_LABEL.get(new Object[0]));
        for (ItemStack item : trader.getStorage().getContents()) {
            list.add((Component)LCText.TOOLTIP_TRADER_GACHA_CONTENTS.get(item.m_41613_(), item.m_41786_()));
        }
        return list;
    }

    private void playDing() {
        SoundManager soundManager = Minecraft.m_91087_().m_91106_();
        if (soundManager != null) {
            soundManager.m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11871_, (float)1.0f));
        }
    }
}

