/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.traders.trade.client;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.client.gui.easy.GhostSlot;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.AlertData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.DisplayData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.DisplayEntry;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidget;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@OnlyIn(value=Dist.CLIENT)
public abstract class TradeRenderManager<T extends TradeData> {
    public final T trade;

    protected TradeRenderManager(T trade) {
        this.trade = trade;
    }

    public abstract int tradeButtonWidth(TradeContext var1);

    public abstract Optional<ScreenPosition> arrowPosition(TradeContext var1);

    public ScreenPosition alertPosition(TradeContext context) {
        return this.arrowPosition(context).orElse(ScreenPosition.ZERO);
    }

    public abstract DisplayData inputDisplayArea(TradeContext var1);

    public abstract List<DisplayEntry> getInputDisplays(TradeContext var1);

    public abstract DisplayData outputDisplayArea(TradeContext var1);

    public abstract List<DisplayEntry> getOutputDisplays(TradeContext var1);

    protected final List<DisplayEntry> lazyPriceDisplayList(TradeContext context) {
        return Lists.newArrayList((Object[])new DisplayEntry[]{this.lazyPriceDisplay(context)});
    }

    protected final List<DisplayEntry> lazyPriceDisplayList(TradeContext context, Component extraTooltip) {
        return Lists.newArrayList((Object[])new DisplayEntry[]{this.lazyPriceDisplay(context, extraTooltip)});
    }

    protected final List<DisplayEntry> lazyPriceDisplayList(TradeContext context, List<Component> extraTooltips) {
        return Lists.newArrayList((Object[])new DisplayEntry[]{this.lazyPriceDisplay(context, extraTooltips)});
    }

    protected final DisplayEntry lazyPriceDisplay(TradeContext context) {
        return this.lazyPriceDisplay(context, (List<Component>)null);
    }

    protected final DisplayEntry lazyPriceDisplay(TradeContext context, Component extraTooltip) {
        if (extraTooltip == null) {
            return this.lazyPriceDisplay(context, (List<Component>)null);
        }
        return this.lazyPriceDisplay(context, Lists.newArrayList((Object[])new Component[]{extraTooltip}));
    }

    protected final DisplayEntry lazyPriceDisplay(TradeContext context, List<Component> extraTooltips) {
        if (context.isStorageMode && this.hasPermission(context, "editTrades")) {
            if (extraTooltips == null) {
                extraTooltips = new ArrayList<Component>();
            }
            extraTooltips.add(0, (Component)LCText.TOOLTIP_TRADE_EDIT_PRICE.getWithStyle(ChatFormatting.YELLOW));
        }
        return DisplayEntry.forMoneyWithAddedTooltip(((TradeData)this.trade).getCost(context), extraTooltips);
    }

    protected final boolean hasPermission(TradeContext context, String permission) {
        TraderData trader = context.getTrader();
        if (trader == null) {
            return false;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        return trader.hasPermission((Player)player, permission);
    }

    protected final int getPermissionLevel(TradeContext context, String permission) {
        TraderData trader = context.getTrader();
        if (trader == null) {
            return 0;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        return trader.getPermissionLevel((Player)player, permission);
    }

    public final List<AlertData> getAlertData(TradeContext context) {
        if (context.isStorageMode) {
            return null;
        }
        ArrayList<AlertData> alerts = new ArrayList<AlertData>();
        this.addTradeRuleAlertData(alerts, context);
        if (context.hasTrader() && context.getTrader().exceedsAcceptableTaxRate()) {
            alerts.add(AlertData.error(LCText.TOOLTIP_TAX_LIMIT.get(new Object[0])));
        }
        this.getAdditionalAlertData(context, alerts);
        return alerts;
    }

    private void addTradeRuleAlertData(List<AlertData> alerts, TradeContext context) {
        if (context.hasTrader() && context.hasPlayerReference()) {
            TradeEvent.PreTradeEvent pte = context.getTrader().runPreTradeEvent((TradeData)this.trade, context);
            alerts.addAll(pte.getAlertInfo());
        }
    }

    protected abstract void getAdditionalAlertData(TradeContext var1, List<AlertData> var2);

    public void renderAdditional(EasyWidget button, EasyGuiGraphics gui, TradeContext context) {
    }

    public List<Component> getAdditionalTooltips(TradeContext context, int mouseX, int mouseY) {
        return null;
    }

    public final MutableComponent getStockTooltip(boolean isCreative, int stockCount) {
        return LCText.TOOLTIP_TRADE_INFO_STOCK.get(isCreative ? LCText.TOOLTIP_TRADE_INFO_STOCK_INFINITE.getWithStyle(ChatFormatting.GOLD) : EasyText.literal(String.valueOf(stockCount)).m_130940_(ChatFormatting.GOLD)).m_130940_(ChatFormatting.GOLD);
    }

    @Nullable
    public final List<GhostSlot<?>> getGhostSlots(TradeContext context, @Nullable ITraderStorageMenu menu, ScreenPosition buttonPos) {
        if (context.isStorageMode) {
            return this.collectGhostSlots(context, menu, buttonPos);
        }
        return null;
    }

    @Nullable
    protected List<GhostSlot<?>> collectGhostSlots(TradeContext context, @Nullable ITraderStorageMenu menu, ScreenPosition buttonPos) {
        return null;
    }
}

