/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.traders.settings.builtin;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.settings.data.LoadContext;
import io.github.lightman314.lightmanscurrency.api.settings.data.SavedSettingData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.settings.EasyTraderSettingsNode;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class MiscSettings
extends EasyTraderSettingsNode<TraderData> {
    public MiscSettings(TraderData trader) {
        super("misc", trader);
    }

    @Override
    public MutableComponent getName() {
        return LCText.DATA_CATEGORY_MISC.get(new Object[0]);
    }

    @Override
    protected String getRequiredPermission() {
        return "editSettings";
    }

    @Override
    public void saveSettings(SavedSettingData.MutableNodeAccess data) {
        data.setBooleanValue("notificationsEnabled", this.trader.notificationsEnabled());
        data.setBooleanValue("notificationsToChat", this.trader.notificationsToChat());
        data.setIntValue("teamNotificationLevel", this.trader.teamNotificationLevel());
        data.setBooleanValue("alwaysShowSearchBox", this.trader.alwaysShowSearchBox());
    }

    @Override
    public void loadSettings(SavedSettingData.NodeAccess data, LoadContext context) {
        this.trader.setNotificationsEnabled(data.getBooleanValue("notificationsEnabled"));
        this.trader.setNotificationsToChat(data.getBooleanValue("notificationsToChat"));
        this.trader.setTeamNotificationLevel(data.getIntValue("teamNotificationLevel"));
        this.trader.setAlwaysShowSearchBox(data.getBooleanValue("alwaysShowSearchBox"));
    }

    @Override
    protected void writeLines(SavedSettingData.NodeAccess data, Consumer<Component> lineWriter) {
        lineWriter.accept((Component)MiscSettings.formatEntry((Component)LCText.DATA_ENTRY_TRADER_NOTIFICATIONS_ENABLED.get(new Object[0]), data.getBooleanValue("notificationsEnabled")));
        lineWriter.accept((Component)MiscSettings.formatEntry((Component)LCText.DATA_ENTRY_TRADER_NOTIFICATIONS_TO_CHAT.get(new Object[0]), data.getBooleanValue("notificationsToChat")));
        lineWriter.accept((Component)MiscSettings.formatEntry((Component)LCText.DATA_ENTRY_TRADER_TEAM_NOTIFICATION_LEVEL.get(new Object[0]), data.getIntValue("teamNotificationLevel")));
        lineWriter.accept((Component)MiscSettings.formatEntry((Component)LCText.DATA_ENTRY_TRADER_ALWAYS_SHOW_SEARCH_BOX.get(new Object[0]), data.getBooleanValue("alwaysShowSearchBox")));
    }
}

