/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.traders;

import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderType;
import io.github.lightman314.lightmanscurrency.api.traders.rules.TradeRuleType;
import io.github.lightman314.lightmanscurrency.api.traders.terminal.ITradeSearchFilter;
import io.github.lightman314.lightmanscurrency.api.traders.terminal.ITraderSearchFilter;
import io.github.lightman314.lightmanscurrency.api.traders.terminal.sorting.SortTypeKey;
import io.github.lightman314.lightmanscurrency.api.traders.terminal.sorting.TerminalSortType;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.common.impl.TraderAPIImpl;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class TraderAPI {
    private static TraderAPI instance;

    public static TraderAPI getApi() {
        if (instance == null) {
            instance = new TraderAPIImpl();
        }
        return instance;
    }

    protected TraderAPI() {
        if (instance != null) {
            throw new IllegalCallerException("Cannot create a new TraderAPI instance as one is already present!");
        }
    }

    public abstract void RegisterTrader(TraderType<?> var1);

    @Nullable
    public abstract TraderType<?> GetTraderType(ResourceLocation var1);

    public abstract void RegisterTradeRule(TradeRuleType<?> var1);

    @Nullable
    public abstract TradeRuleType<?> GetTradeRuleType(ResourceLocation var1);

    public abstract List<TradeRuleType<?>> GetAllTradeRuleTypes();

    public abstract void RegisterTraderSearchFilter(ITraderSearchFilter var1);

    public abstract boolean FilterTrader(TraderData var1, String var2);

    public abstract List<TraderData> FilterTraders(List<TraderData> var1, String var2);

    public abstract void RegisterTradeSearchFilter(ITradeSearchFilter var1);

    public abstract boolean FilterTrade(TradeData var1, String var2);

    public abstract List<TradeData> FilterTrades(List<TradeData> var1, String var2);

    public abstract <T extends ITraderSearchFilter & ITradeSearchFilter> void RegisterSearchFilter(T var1);

    public abstract void RegisterSortType(TerminalSortType var1);

    @Nullable
    public abstract TerminalSortType GetSortType(ResourceLocation var1);

    @Nullable
    public abstract TerminalSortType GetSortType(SortTypeKey var1);

    public abstract List<TerminalSortType> GetAllSortTypes();

    public abstract List<SortTypeKey> GetAllSortTypeKeys();

    @Nullable
    public final TraderData GetTrader(IClientTracker context, long traderID) {
        return this.GetTrader(context.isClient(), traderID);
    }

    @Nullable
    public abstract TraderData GetTrader(boolean var1, long var2);

    public final List<TraderData> GetAllTraders(IClientTracker context) {
        return this.GetAllTraders(context.isClient());
    }

    public abstract List<TraderData> GetAllTraders(boolean var1);

    public final List<TraderData> GetAllNetworkTraders(IClientTracker context) {
        return this.GetAllNetworkTraders(context.isClient());
    }

    public abstract List<TraderData> GetAllNetworkTraders(boolean var1);

    public final long CreateTrader(TraderData newTrader) {
        return this.CreateTrader(newTrader, null);
    }

    public abstract long CreateTrader(TraderData var1, @Nullable Player var2);

    public final void DeleteTrader(TraderData trader) {
        this.DeleteTrader(trader.getID());
    }

    public abstract void DeleteTrader(long var1);
}

