/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.trader_interface.blockentity;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.ejection.EjectionData;
import io.github.lightman314.lightmanscurrency.api.ejection.IDumpable;
import io.github.lightman314.lightmanscurrency.api.ejection.builtin.BasicEjectionData;
import io.github.lightman314.lightmanscurrency.api.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.api.misc.IServerTicker;
import io.github.lightman314.lightmanscurrency.api.misc.QuarantineAPI;
import io.github.lightman314.lightmanscurrency.api.misc.blockentity.EasyBlockEntity;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IRotatableBlock;
import io.github.lightman314.lightmanscurrency.api.misc.player.OwnerData;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.money.bank.IBankAccount;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.api.ownership.Owner;
import io.github.lightman314.lightmanscurrency.api.ownership.builtin.PlayerOwner;
import io.github.lightman314.lightmanscurrency.api.stats.StatKeys;
import io.github.lightman314.lightmanscurrency.api.stats.StatTracker;
import io.github.lightman314.lightmanscurrency.api.trader_interface.blocks.TraderInterfaceBlock;
import io.github.lightman314.lightmanscurrency.api.trader_interface.data.TradeReference;
import io.github.lightman314.lightmanscurrency.api.trader_interface.data.TraderInterfaceTargets;
import io.github.lightman314.lightmanscurrency.api.traders.FullTradeResult;
import io.github.lightman314.lightmanscurrency.api.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.api.traders.TradeResult;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeDirection;
import io.github.lightman314.lightmanscurrency.api.upgrades.IUpgradeable;
import io.github.lightman314.lightmanscurrency.api.upgrades.IUpgradeableBlockEntity;
import io.github.lightman314.lightmanscurrency.api.upgrades.UpgradeType;
import io.github.lightman314.lightmanscurrency.common.items.UpgradeItem;
import io.github.lightman314.lightmanscurrency.common.menus.TraderInterfaceMenu;
import io.github.lightman314.lightmanscurrency.common.menus.containers.UpgradeContainer;
import io.github.lightman314.lightmanscurrency.common.menus.providers.EasyMenuProvider;
import io.github.lightman314.lightmanscurrency.common.traderinterface.handlers.SidedHandler;
import io.github.lightman314.lightmanscurrency.common.upgrades.Upgrades;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.SpeedUpgrade;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import io.github.lightman314.lightmanscurrency.network.message.interfacebe.CPacketInterfaceHandlerMessage;
import io.github.lightman314.lightmanscurrency.util.BlockEntityUtil;
import io.github.lightman314.lightmanscurrency.util.EnumUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public abstract class TraderInterfaceBlockEntity
extends EasyBlockEntity
implements IUpgradeable,
IDumpable,
IServerTicker,
IUpgradeableBlockEntity {
    public static final int INTERACTION_DELAY = 20;
    private boolean allowRemoval = false;
    public final OwnerData owner = new OwnerData((IClientTracker)this, this::OnOwnerChanged);
    public final StatTracker statTracker = new StatTracker(() -> {}, this);
    List<SidedHandler<?>> handlers = new ArrayList();
    private ActiveMode mode = ActiveMode.DISABLED;
    private boolean onlineMode = false;
    private InteractionType interaction = InteractionType.TRADE;
    public final TraderInterfaceTargets targets = new TraderInterfaceTargets(this);
    private final UpgradeContainer upgradeSlots = new UpgradeContainer(5, this);
    private int waitTimer = 20;

    public boolean allowRemoval() {
        return this.allowRemoval;
    }

    public void flagAsRemovable() {
        this.allowRemoval = true;
    }

    public void initOwner(Entity owner) {
        if (!this.owner.hasOwner() && owner instanceof Player) {
            Player player = (Player)owner;
            this.owner.SetOwner(PlayerOwner.of(player));
        }
    }

    private void OnOwnerChanged() {
        this.mode = ActiveMode.DISABLED;
        this.m_6596_();
        if (!this.isClient()) {
            BlockEntityUtil.sendUpdatePacket((BlockEntity)this, this.saveOwner(this.saveMode(new CompoundTag())));
        }
    }

    public PlayerReference getReferencedPlayer() {
        return this.owner.getPlayerForContext();
    }

    public MutableComponent getOwnerName() {
        return this.owner.getName();
    }

    @Nullable
    public IBankAccount getBankAccount() {
        BankReference reference = this.getAccountReference();
        if (reference != null) {
            return reference.get();
        }
        return null;
    }

    @Nullable
    public BankReference getAccountReference() {
        if (QuarantineAPI.IsDimensionQuarantined(this)) {
            return null;
        }
        return this.owner.getValidOwner().asBankReference();
    }

    public ActiveMode getMode() {
        return this.mode;
    }

    public void setMode(ActiveMode mode) {
        this.mode = mode;
        this.setModeDirty();
    }

    public boolean isOnlineMode() {
        return this.onlineMode;
    }

    public void setOnlineMode(boolean onlineMode) {
        this.onlineMode = onlineMode;
        this.setOnlineModeDirty();
    }

    public InteractionType getInteractionType() {
        return this.interaction;
    }

    public void setInteractionType(InteractionType type) {
        if (this.getBlacklistedInteractions().contains((Object)type)) {
            LightmansCurrency.LogInfo("Attempted to set interaction type to " + type.name() + ", but that type is blacklisted for this interface type (" + this.getClass().getName() + ").");
            return;
        }
        this.interaction = type;
        this.setInteractionDirty();
    }

    public List<InteractionType> getBlacklistedInteractions() {
        return new ArrayList<InteractionType>();
    }

    @Override
    @Nonnull
    public Container getUpgrades() {
        return this.upgradeSlots;
    }

    public int getSelectableCount() {
        int count = 1;
        for (int i = 0; i < this.upgradeSlots.m_6643_(); ++i) {
            UpgradeItem upgradeItem;
            ItemStack stack = this.upgradeSlots.m_8020_(i);
            Item item = stack.m_41720_();
            if (!(item instanceof UpgradeItem) || (upgradeItem = (UpgradeItem)item).getUpgradeType() != Upgrades.INTERACTION) continue;
            count += UpgradeItem.getUpgradeData(stack).getIntValue("interactions");
        }
        return count;
    }

    public void setUpgradeSlotsDirty() {
        this.m_6596_();
        if (!this.isClient()) {
            BlockEntityUtil.sendUpdatePacket((BlockEntity)this, this.saveUpgradeSlots(new CompoundTag()));
        }
    }

    public void toggleTrader(long traderID) {
        if (this.targets.toggleTrader(traderID)) {
            this.setTargetsDirty();
        }
    }

    public void toggleTradeIndex(int tradeIndex) {
        if (this.targets.toggleTrade(tradeIndex)) {
            this.setTargetsDirty();
        }
    }

    public void acceptTradeChanges(int entry) {
        List<TradeReference> references = this.targets.getTradeReferences();
        if (entry < 0 || entry >= references.size()) {
            return;
        }
        references.get(entry).refreshTrade();
        this.setTargetsDirty();
    }

    @Nullable
    public abstract TradeData deserializeTrade(CompoundTag var1);

    public boolean canAccess(Player player) {
        return this.owner.isMember(player);
    }

    public boolean isOwner(Player player) {
        return this.owner.isAdmin(player);
    }

    protected TraderInterfaceBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void setModeDirty() {
        this.m_6596_();
        if (!this.isClient()) {
            BlockEntityUtil.sendUpdatePacket((BlockEntity)this, this.saveMode(new CompoundTag()));
        }
    }

    public void setOnlineModeDirty() {
        this.m_6596_();
        if (!this.isClient()) {
            BlockEntityUtil.sendUpdatePacket((BlockEntity)this, this.saveOnlineMode(new CompoundTag()));
        }
    }

    public void setStatsDirty() {
        this.m_6596_();
        if (!this.isClient()) {
            BlockEntityUtil.sendUpdatePacket((BlockEntity)this, this.saveStatTracker(new CompoundTag()));
        }
    }

    protected abstract TradeContext.Builder buildTradeContext(TradeContext.Builder var1);

    public TradeContext getTradeContext(@Nonnull TraderData trader) {
        if (this.interaction.trades()) {
            return this.buildTradeContext(TradeContext.create(trader, this.getReferencedPlayer()).withBankAccount(this.getAccountReference())).build();
        }
        return TradeContext.createStorageMode(trader);
    }

    protected final <H extends SidedHandler<?>> H addHandler(@Nonnull H handler) {
        handler.setParent(this);
        this.handlers.add(handler);
        return handler;
    }

    @Override
    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag compound) {
        this.saveOwner(compound);
        this.saveMode(compound);
        this.saveOnlineMode(compound);
        this.saveInteraction(compound);
        this.saveTargets(compound);
        this.saveUpgradeSlots(compound);
        this.saveStatTracker(compound);
        for (SidedHandler<?> handler : this.handlers) {
            this.saveHandler(compound, handler);
        }
    }

    protected final CompoundTag saveOwner(CompoundTag compound) {
        if (this.owner != null) {
            compound.m_128365_("Owner", (Tag)this.owner.save());
        }
        return compound;
    }

    protected final CompoundTag saveMode(CompoundTag compound) {
        compound.m_128359_("Mode", this.mode.name());
        return compound;
    }

    protected final CompoundTag saveOnlineMode(CompoundTag compound) {
        compound.m_128379_("OnlineMode", this.onlineMode);
        return compound;
    }

    protected final CompoundTag saveInteraction(CompoundTag compound) {
        compound.m_128359_("InteractionType", this.interaction.name());
        return compound;
    }

    protected final CompoundTag saveTargets(CompoundTag compound) {
        compound.m_128365_("Targets", (Tag)this.targets.save());
        return compound;
    }

    protected final CompoundTag saveUpgradeSlots(CompoundTag compound) {
        this.upgradeSlots.save("Upgrades", compound);
        return compound;
    }

    protected final CompoundTag saveStatTracker(CompoundTag compound) {
        compound.m_128365_("Stats", (Tag)this.statTracker.save());
        return compound;
    }

    protected final CompoundTag saveHandler(CompoundTag compound, SidedHandler<?> handler) {
        compound.m_128365_(handler.getTag(), (Tag)handler.save());
        return compound;
    }

    public void setHandlerDirty(SidedHandler<?> handler) {
        this.m_6596_();
        if (this.isServer()) {
            BlockEntityUtil.sendUpdatePacket((BlockEntity)this, this.saveHandler(new CompoundTag(), handler));
        }
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag compound) {
        if (compound.m_128425_("Owner", 10)) {
            this.owner.load(compound.m_128469_("Owner"));
        }
        if (compound.m_128441_("Mode")) {
            this.mode = (ActiveMode)EnumUtil.enumFromString((String)compound.m_128461_("Mode"), (Enum[])ActiveMode.values(), (Enum)ActiveMode.DISABLED);
        }
        if (compound.m_128441_("OnlineMode")) {
            this.onlineMode = compound.m_128471_("OnlineMode");
        }
        if (compound.m_128425_("InteractionType", 8)) {
            this.interaction = (InteractionType)EnumUtil.enumFromString((String)compound.m_128461_("InteractionType"), (Enum[])InteractionType.values(), (Enum)InteractionType.TRADE);
        }
        if (compound.m_128425_("Trade", 10)) {
            this.targets.loadFromOldData(compound.m_128469_("Trade"));
        }
        if (compound.m_128425_("Targets", 10)) {
            this.targets.load(compound.m_128469_("Targets"));
        }
        if (compound.m_128441_("Upgrades")) {
            this.upgradeSlots.load("Upgrades", compound);
        }
        if (compound.m_128441_("Stats")) {
            this.statTracker.load(compound.m_128469_("Stats"));
        }
        for (SidedHandler<?> handler : this.handlers) {
            if (!compound.m_128425_(handler.getTag(), 10)) continue;
            handler.load(compound.m_128469_(handler.getTag()));
        }
    }

    public void setInteractionDirty() {
        this.m_6596_();
        if (!this.isClient()) {
            BlockEntityUtil.sendUpdatePacket((BlockEntity)this, this.saveInteraction(new CompoundTag()));
        }
    }

    @NotNull
    public <C> LazyOptional<C> getCapability(@Nonnull Capability<C> cap, @Nullable Direction side) {
        Direction relativeSide = this.getRelativeSide(side);
        for (SidedHandler<?> sidedHandler : this.handlers) {
            Object handler = sidedHandler.getHandler(relativeSide);
            if (cap == ForgeCapabilities.ITEM_HANDLER && handler instanceof IItemHandler) {
                return LazyOptional.of(() -> (IItemHandler)handler).cast();
            }
            if (cap == ForgeCapabilities.FLUID_HANDLER && handler instanceof IFluidHandler) {
                return LazyOptional.of(() -> (IFluidHandler)handler).cast();
            }
            if (cap != ForgeCapabilities.ENERGY || !(handler instanceof IEnergyStorage)) continue;
            return LazyOptional.of(() -> (IEnergyStorage)handler).cast();
        }
        return super.getCapability(cap, side);
    }

    protected final Direction getRelativeSide(Direction side) {
        Direction relativeSide = side;
        if (relativeSide != null & this.m_58900_().m_60734_() instanceof IRotatableBlock) {
            relativeSide = IRotatableBlock.getRelativeSide(((IRotatableBlock)this.m_58900_().m_60734_()).getFacing(this.m_58900_()), side);
        }
        return relativeSide;
    }

    public void sendHandlerMessage(ResourceLocation type, CompoundTag message) {
        if (this.isClient()) {
            new CPacketInterfaceHandlerMessage(this.f_58858_, type, message).send();
        }
    }

    public void receiveHandlerMessage(ResourceLocation type, Player player, CompoundTag message) {
        if (!this.canAccess(player)) {
            return;
        }
        for (SidedHandler<?> handler : this.handlers) {
            if (!handler.getType().equals((Object)type)) continue;
            handler.receiveMessage(message);
        }
    }

    public void setTargetsDirty() {
        this.m_6596_();
        if (!this.isClient()) {
            BlockEntityUtil.sendUpdatePacket((BlockEntity)this, this.saveTargets(new CompoundTag()));
        }
    }

    @Nonnull
    public FullTradeResult TryExecuteTrade(@Nonnull TradeReference target) {
        TraderData trader = this.targets.getTrader();
        if (trader != null) {
            TradeContext context = this.getTradeContext(trader);
            FullTradeResult result = trader.TryExecuteTradeWithResults(context, target.getTradeIndex());
            target.setLastResult(result.simpleResult);
            if (result.isSuccess()) {
                TradeEvent.PostTradeEvent data = result.data;
                TradeData trade = data.getTrade();
                if (trade.getTradeDirection() == TradeDirection.SALE) {
                    this.statTracker.incrementStat(StatKeys.Generic.MONEY_PAID, data.getPricePaid());
                } else if (trade.getTradeDirection() == TradeDirection.PURCHASE) {
                    this.statTracker.incrementStat(StatKeys.Generic.MONEY_EARNED, data.getPricePaid());
                }
                this.statTracker.incrementStat(StatKeys.Traders.TRADES_EXECUTED, 1);
                this.setStatsDirty();
            }
            return result;
        }
        target.setLastResult(TradeResult.FAIL_NULL);
        return FullTradeResult.failure(TradeResult.FAIL_NULL);
    }

    public boolean isActive() {
        return this.mode.isActive(this) && this.onlineCheck();
    }

    public boolean onlineCheck() {
        if (this.isClient()) {
            return false;
        }
        if (!this.onlineMode) {
            return true;
        }
        return this.owner.getValidOwner().isOnline();
    }

    public final boolean hasTraderPermissions(TraderData trader) {
        if (trader == null) {
            return false;
        }
        Owner owner = this.owner.getValidOwner();
        if (owner instanceof PlayerOwner) {
            PlayerOwner po = (PlayerOwner)owner;
            return trader.hasPermission(po.player, "interactionLink");
        }
        return trader.getOwner().getValidOwner().matches(this.owner.getValidOwner());
    }

    @Override
    public void serverTick() {
        if (QuarantineAPI.IsDimensionQuarantined(this)) {
            return;
        }
        if (this.targets.tick(this::validTrader)) {
            this.setTargetsDirty();
        }
        if (this.isActive() && --this.waitTimer <= 0) {
            this.waitTimer = this.getInteractionDelay();
            if (this.interaction.targetsTraders()) {
                for (TraderData trader : this.targets.getTraders()) {
                    if (!this.validTrader(trader) && !this.hasTraderPermissions(trader)) continue;
                    if (this.interaction.drains()) {
                        this.drainTick(trader);
                    }
                    if (!this.interaction.restocks()) continue;
                    this.restockTick(trader);
                }
            } else if (this.interaction.trades()) {
                for (TradeReference trade : this.targets.getTradeReferences()) {
                    if (!this.validTrade(trade)) continue;
                    this.tradeTick(trade);
                }
            }
            if (this.hasHopperUpgrade()) {
                this.hopperTick();
            }
        }
    }

    public boolean validTrader(@Nonnull TraderData trader) {
        return trader != null && this.validTraderType(trader);
    }

    public boolean validTrade(@Nonnull TradeReference trade) {
        TradeData expectedTrade = trade.getLocalTrade();
        TradeData trueTrade = trade.getTrueTrade();
        if (expectedTrade == null || trueTrade == null) {
            return false;
        }
        return trueTrade.AcceptableDifferences(trueTrade.compare(expectedTrade));
    }

    public abstract boolean validTraderType(TraderData var1);

    protected abstract void drainTick(@Nonnull TraderData var1);

    protected abstract void restockTick(@Nonnull TraderData var1);

    protected abstract void tradeTick(@Nonnull TradeReference var1);

    protected abstract void hopperTick();

    public void openMenu(Player player) {
        if (this.canAccess(player)) {
            MenuProvider provider = this.getMenuProvider();
            if (provider == null) {
                return;
            }
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)provider, (BlockPos)this.f_58858_);
        }
    }

    protected MenuProvider getMenuProvider() {
        return new InterfaceMenuProvider(this);
    }

    protected int getInteractionDelay() {
        int delay = 20;
        for (int i = 0; i < this.upgradeSlots.m_6643_() && delay > 1; ++i) {
            UpgradeItem upgrade;
            ItemStack stack = this.upgradeSlots.m_8020_(i);
            Item item = stack.m_41720_();
            if (!(item instanceof UpgradeItem) || !((upgrade = (UpgradeItem)item).getUpgradeType() instanceof SpeedUpgrade)) continue;
            delay -= UpgradeItem.getUpgradeData(stack).getIntValue(SpeedUpgrade.DELAY_AMOUNT);
        }
        return delay;
    }

    public abstract void initMenuTabs(TraderInterfaceMenu var1);

    @Override
    public boolean allowUpgrade(@Nonnull UpgradeType type) {
        return type == Upgrades.SPEED || type == Upgrades.HOPPER && this.allowHopperUpgrade() && !this.hasHopperUpgrade() || type == Upgrades.INTERACTION || this.allowAdditionalUpgrade(type);
    }

    protected boolean allowHopperUpgrade() {
        return true;
    }

    protected boolean allowAdditionalUpgrade(UpgradeType type) {
        return false;
    }

    protected final boolean hasHopperUpgrade() {
        return UpgradeType.hasUpgrade(Upgrades.HOPPER, (Container)this.upgradeSlots);
    }

    @Nonnull
    public final List<ItemStack> getContents(Level level, BlockPos pos, BlockState state, boolean dropBlock) {
        ArrayList<ItemStack> contents = new ArrayList<ItemStack>();
        if (dropBlock && state != null) {
            if (state.m_60734_() instanceof TraderInterfaceBlock) {
                contents.add(((TraderInterfaceBlock)state.m_60734_()).getDropBlockItem(state, this));
            } else {
                contents.add(new ItemStack((ItemLike)state.m_60734_()));
            }
        }
        for (int i = 0; i < this.upgradeSlots.m_6643_(); ++i) {
            if (this.upgradeSlots.m_8020_(i).m_41619_()) continue;
            contents.add(this.upgradeSlots.m_8020_(i));
        }
        this.getAdditionalContents(contents);
        return contents;
    }

    protected abstract void getAdditionalContents(List<ItemStack> var1);

    @Override
    @Nonnull
    public EjectionData buildEjectionData(@Nonnull Level level, @Nonnull BlockPos pos, @Nullable BlockState state) {
        List<ItemStack> contents = this.getContents(level, pos, state, true);
        return new BasicEjectionData(this.owner, contents, (Component)(state == null ? LCText.BLOCK_ITEM_TRADER_INTERFACE.get(new Object[0]) : state.m_60734_().m_49954_()));
    }

    public static enum ActiveMode {
        DISABLED(0, be -> false),
        REDSTONE_OFF(1, be -> {
            if (((TraderInterfaceBlockEntity)be).f_58857_ != null) {
                return !((TraderInterfaceBlockEntity)be).f_58857_.m_276867_(be.m_58899_());
            }
            return false;
        }),
        REDSTONE_ONLY(2, be -> {
            if (((TraderInterfaceBlockEntity)be).f_58857_ != null) {
                return ((TraderInterfaceBlockEntity)be).f_58857_.m_276867_(be.m_58899_());
            }
            return false;
        }),
        ALWAYS_ON(3, be -> true);

        public final int index;
        private final Function<TraderInterfaceBlockEntity, Boolean> active;

        public final Component getDisplayText() {
            return LCText.GUI_INTERFACE_ACTIVE_MODE.get(this).get(new Object[0]);
        }

        public final ActiveMode getNext() {
            return ActiveMode.fromIndex(this.index + 1);
        }

        public boolean isActive(TraderInterfaceBlockEntity blockEntity) {
            return this.active.apply(blockEntity);
        }

        private ActiveMode(int index, Function<TraderInterfaceBlockEntity, Boolean> active) {
            this.index = index;
            this.active = active;
        }

        public static ActiveMode fromIndex(int index) {
            for (ActiveMode mode : ActiveMode.values()) {
                if (mode.index != index) continue;
                return mode;
            }
            return DISABLED;
        }
    }

    public static enum InteractionType {
        RESTOCK_AND_DRAIN(3),
        RESTOCK(1),
        DRAIN(2),
        TRADE(0);

        public final int index;

        public final Component getDisplayText() {
            return LCText.GUI_INTERFACE_INTERACTION_TYPE.get(this).get(new Object[0]);
        }

        private InteractionType(int index) {
            this.index = index;
        }

        public boolean targetsTraders() {
            return this != TRADE;
        }

        public boolean restocks() {
            return this == RESTOCK || this == RESTOCK_AND_DRAIN;
        }

        public boolean drains() {
            return this == DRAIN || this == RESTOCK_AND_DRAIN;
        }

        public boolean trades() {
            return this == TRADE;
        }

        public static InteractionType fromIndex(int index) {
            for (InteractionType type : InteractionType.values()) {
                if (type.index != index) continue;
                return type;
            }
            return TRADE;
        }

        public static int size() {
            return 4;
        }
    }

    public static class InterfaceMenuProvider
    implements EasyMenuProvider {
        private final TraderInterfaceBlockEntity blockEntity;

        public InterfaceMenuProvider(TraderInterfaceBlockEntity blockEntity) {
            this.blockEntity = blockEntity;
        }

        public AbstractContainerMenu m_7208_(int windowID, @NotNull Inventory inventory, @NotNull Player player) {
            return new TraderInterfaceMenu(windowID, inventory, this.blockEntity);
        }
    }
}

