/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.ownership.listing;

import io.github.lightman314.lightmanscurrency.api.misc.icons.IconData;
import io.github.lightman314.lightmanscurrency.api.ownership.Owner;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class PotentialOwner
implements IClientTracker {
    private final Owner owner;
    private boolean isClient;
    private int priority;
    private boolean currentOwner;

    @Override
    public final boolean isClient() {
        return this.isClient;
    }

    public final void flagAsClient() {
        this.isClient = true;
    }

    protected final void setPriority(int priority) {
        this.priority = priority;
    }

    public final void addPriority(int priority) {
        this.priority += priority;
    }

    public final int getPriority() {
        return this.currentOwner ? 0x7FFFFFFE : this.priority;
    }

    public final int sortingPriority() {
        return this.getPriority() * -1;
    }

    public final void flagAsHighPriority() {
        this.priority = 0x7FFFFFFD;
    }

    public final void setAsCurrentOwner(boolean isCurrentOwner) {
        this.currentOwner = isCurrentOwner;
    }

    protected PotentialOwner(Owner owner) {
        this(owner, 0);
    }

    protected PotentialOwner(Owner owner, int priority) {
        this.owner = owner;
        this.owner.setParent(this);
        this.priority = priority;
    }

    public final Owner asOwner() {
        return this.owner;
    }

    public boolean failedFilter(String searchFilter) {
        return !this.getName().getString().toLowerCase().contains(searchFilter.toLowerCase());
    }

    public MutableComponent getName() {
        return this.asOwner().getName();
    }

    public abstract IconData getIcon();

    public abstract void appendTooltip(List<Component> var1);
}

