/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.notifications;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconData;
import io.github.lightman314.lightmanscurrency.api.misc.icons.ItemIcon;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategoryType;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.tab.ITab;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class NotificationCategory
implements ITab {
    public static final NotificationCategoryType<?> GENERAL_TYPE = new NotificationCategoryType(VersionUtil.lcResource("general"), NotificationCategory::getGeneral);
    public static final NotificationCategory GENERAL = new NotificationCategory(){

        @Override
        public IconData getIcon() {
            return ItemIcon.ofItem((ItemLike)Items.f_42009_);
        }

        @Override
        public Component getName() {
            return LCText.NOTIFICATION_SOURCE_GENERAL.get(new Object[0]);
        }

        @Override
        public boolean matches(NotificationCategory other) {
            return other == GENERAL;
        }

        @Override
        protected NotificationCategoryType<?> getType() {
            return GENERAL_TYPE;
        }

        @Override
        protected void saveAdditional(CompoundTag compound) {
        }
    };

    @Override
    public final Component getTooltip() {
        return this.getName();
    }

    public abstract Component getName();

    protected abstract NotificationCategoryType<?> getType();

    public abstract boolean matches(NotificationCategory var1);

    private static NotificationCategory getGeneral(CompoundTag ignored) {
        return GENERAL;
    }

    public final CompoundTag save() {
        CompoundTag compound = new CompoundTag();
        compound.m_128359_("type", this.getType().toString());
        this.saveAdditional(compound);
        return compound;
    }

    protected abstract void saveAdditional(CompoundTag var1);

    public final boolean notGeneral() {
        return this != GENERAL;
    }
}

