/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.notifications;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.ISidedObject;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationType;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class Notification
implements ISidedObject {
    private boolean isClient = false;
    private long timeStamp = TimeUtil.getCurrentTime();
    private boolean seen = false;
    private int count = 1;

    @Override
    public final boolean isClient() {
        return this.isClient;
    }

    @Override
    public final boolean isServer() {
        return ISidedObject.super.isServer();
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public final boolean hasTimeStamp() {
        return this.getTimeStamp() > 0L;
    }

    public boolean wasSeen() {
        return this.seen;
    }

    public void setSeen() {
        this.seen = true;
    }

    public int getCount() {
        return this.count;
    }

    protected Notification() {
    }

    protected abstract NotificationType<?> getType();

    public abstract NotificationCategory getCategory();

    public abstract List<Component> getMessageLines();

    public List<Component> getGeneralMessage() {
        return this.getModifiedMessage(line -> LCText.NOTIFICATION_FORMAT_GENERAL.get(this.getCategory().getName(), line));
    }

    public List<Component> getChatMessage() {
        return this.getModifiedMessage(line -> LCText.NOTIFICATION_FORMAT_CHAT.get(LCText.NOTIFICATION_FORMAT_CHAT_TITLE.get(this.getCategory().getName()).m_130940_(ChatFormatting.GOLD), line));
    }

    protected final List<Component> getModifiedMessage(UnaryOperator<Component> edit) {
        ArrayList<Component> message = new ArrayList<Component>(this.getMessageLines());
        if (message.isEmpty()) {
            return message;
        }
        message.set(0, (Component)edit.apply((Component)message.get(0)));
        return message;
    }

    public Component getTimeStampMessage() {
        return LCText.NOTIFICATION_TIMESTAMP.get(TimeUtil.formatTime(this.timeStamp));
    }

    public final CompoundTag save() {
        CompoundTag compound = new CompoundTag();
        if (this.seen) {
            compound.m_128379_("Seen", true);
        }
        compound.m_128405_("Count", this.count);
        compound.m_128359_("Type", this.getType().type.toString());
        if (this.timeStamp > 0L) {
            compound.m_128356_("TimeStamp", this.timeStamp);
        }
        try {
            this.saveAdditional(compound);
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error saving Notification of type '" + this.getType().type.toString() + "'", t);
        }
        return compound;
    }

    protected abstract void saveAdditional(CompoundTag var1);

    public final void load(CompoundTag compound) {
        if (compound.m_128441_("Seen")) {
            this.seen = true;
        }
        if (compound.m_128425_("Count", 3)) {
            this.count = compound.m_128451_("Count");
        }
        this.timeStamp = compound.m_128425_("TimeStamp", 4) ? compound.m_128454_("TimeStamp") : 0L;
        this.loadAdditional(compound);
    }

    protected abstract void loadAdditional(CompoundTag var1);

    public boolean onNewNotification(Notification other) {
        if (this.canMerge(other)) {
            ++this.count;
            this.seen = false;
            this.timeStamp = TimeUtil.getCurrentTime();
            return true;
        }
        return false;
    }

    protected abstract boolean canMerge(Notification var1);

    @Override
    public Notification flagAsClient() {
        return this.flagAsClient(true);
    }

    @Override
    public Notification flagAsClient(boolean isClient) {
        this.isClient = isClient;
        return this;
    }

    @Override
    public Notification flagAsClient(IClientTracker context) {
        return this.flagAsClient(context.isClient());
    }
}

