/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.money.bank;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.money.bank.salary.CustomTarget;
import io.github.lightman314.lightmanscurrency.api.money.bank.salary.SalaryData;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyStorage;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.holder.IMoneyHolder;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.stats.StatTracker;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public interface IBankAccount
extends IMoneyHolder,
IClientTracker {
    public static final int SALARY_LIMIT = 100;

    public MoneyStorage getMoneyStorage();

    public int getCardValidation();

    public boolean isCardValid(int var1);

    public void resetCards();

    public MutableComponent getName();

    public Component getOwnerName();

    public Map<String, MoneyValue> getNotificationLevels();

    public MoneyValue getNotificationLevelFor(String var1);

    public void setNotificationLevel(String var1, MoneyValue var2);

    public void pushLocalNotification(Notification var1);

    default public void pushNotification(Supplier<Notification> notification) {
        this.pushNotification(notification, true);
    }

    public void pushNotification(Supplier<Notification> var1, boolean var2);

    public List<Notification> getNotifications();

    default public MutableComponent getBalanceText() {
        return LCText.GUI_BANK_BALANCE.get(this.getMoneyStorage().getRandomValueText());
    }

    public void depositMoney(MoneyValue var1);

    public MoneyValue withdrawMoney(MoneyValue var1);

    public void applyInterest(double var1, List<MoneyValue> var3, List<String> var4, boolean var5, boolean var6);

    public List<SalaryData> getSalaries();

    default public void checkForOnlinePlayers() {
        for (SalaryData s : this.getSalaries()) {
            s.checkForOnlinePlayers();
        }
    }

    public Map<String, CustomTarget> extraSalaryTargets();

    @Nullable
    public StatTracker getStatTracker();

    public void markDirty();

    public void tick();
}

