/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.misc.player;

import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.ownership.Owner;
import io.github.lightman314.lightmanscurrency.api.ownership.builtin.FakeOwner;
import io.github.lightman314.lightmanscurrency.api.ownership.builtin.PlayerOwner;
import io.github.lightman314.lightmanscurrency.api.ownership.builtin.TeamOwner;
import io.github.lightman314.lightmanscurrency.common.player.LCAdminMode;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public final class OwnerData
implements IClientTracker {
    private Owner backupOwner = Owner.getNull(this);
    private Owner currentOwner = Owner.getNull(this);
    private IClientTracker parent;
    private final Consumer<OwnerData> onChanged;

    @Override
    public boolean isClient() {
        return this.parent.isClient();
    }

    public OwnerData withParent(IClientTracker parent) {
        this.parent = parent;
        return this;
    }

    public static OwnerData parseUnsided(CompoundTag tag) {
        OwnerData data = new OwnerData();
        data.load(tag);
        return data;
    }

    public OwnerData() {
        this(IClientTracker.forClient(), (OwnerData o) -> {});
    }

    public OwnerData(IClientTracker parent) {
        this(parent, (OwnerData o) -> {});
    }

    public OwnerData(IClientTracker parent, Runnable onChanged) {
        this(parent, (OwnerData o) -> onChanged.run());
    }

    public OwnerData(IClientTracker parent, Consumer<OwnerData> onChanged) {
        this.parent = parent;
        this.onChanged = onChanged;
    }

    public Owner getValidOwner() {
        return this.currentOwner.stillValid() ? this.currentOwner : this.backupOwner;
    }

    public boolean hasOwner() {
        return this.currentOwner.stillValid() || this.backupOwner.stillValid();
    }

    public CompoundTag save() {
        CompoundTag compound = new CompoundTag();
        compound.m_128365_("BackupOwner", (Tag)this.backupOwner.save());
        compound.m_128365_("Owner", (Tag)this.currentOwner.save());
        return compound;
    }

    public void load(CompoundTag compound) {
        if (compound.m_128441_("BackupOwner") && compound.m_128441_("Owner")) {
            this.backupOwner = Owner.load(compound.m_128469_("BackupOwner"));
            this.currentOwner = Owner.load(compound.m_128469_("Owner"));
        } else {
            this.backupOwner = FakeOwner.of("NULL");
            if (compound.m_128441_("Custom")) {
                MutableComponent custom = Component.Serializer.m_130701_((String)compound.m_128461_("Custom"));
                this.backupOwner = FakeOwner.of(custom.m_6881_());
                this.currentOwner = FakeOwner.of(custom);
            }
            if (compound.m_128441_("Player")) {
                PlayerReference player = PlayerReference.load(compound.m_128469_("Player"));
                this.backupOwner = PlayerOwner.of(player);
                this.currentOwner = PlayerOwner.of(player);
            }
            if (compound.m_128441_("Team")) {
                this.currentOwner = TeamOwner.of(compound.m_128454_("Team"));
            }
        }
        if (this.backupOwner == null) {
            this.backupOwner = Owner.getNull();
        }
        this.backupOwner.setParent(this);
        if (this.currentOwner == null) {
            this.currentOwner = Owner.getNull();
        }
        this.currentOwner.setParent(this);
    }

    public void copyFrom(OwnerData owner) {
        this.backupOwner = owner.backupOwner.copy();
        this.backupOwner.setParent(this);
        this.currentOwner = owner.currentOwner.copy();
        this.currentOwner.setParent(this);
    }

    public PlayerReference getPlayerForContext() {
        return this.getValidOwner().asPlayerReference();
    }

    public boolean isAdmin(Player player) {
        return LCAdminMode.isAdminPlayer(player) || this.isAdmin(PlayerReference.of(player));
    }

    public boolean isAdmin(PlayerReference player) {
        return this.getValidOwner().isAdmin(player);
    }

    public boolean isMember(Player player) {
        return LCAdminMode.isAdminPlayer(player) || this.isMember(PlayerReference.of(player));
    }

    public boolean isMember(PlayerReference player) {
        return this.getValidOwner().isMember(player);
    }

    public MutableComponent getName() {
        return this.getValidOwner().getName();
    }

    public void SetOwner(Owner newOwner) {
        this.currentOwner = newOwner.copy();
        this.currentOwner.setParent(this);
        if (this.currentOwner.alwaysValid()) {
            this.backupOwner = this.currentOwner.copy();
            this.backupOwner.setParent(this);
        }
        this.setChanged();
    }

    public void setChanged() {
        this.onChanged.accept(this);
    }

    public boolean equals(Object obj) {
        if (obj instanceof OwnerData) {
            OwnerData owner = (OwnerData)obj;
            return owner.currentOwner.matches(this.currentOwner) && owner.backupOwner.matches(this.backupOwner);
        }
        return false;
    }

    public int hashCode() {
        return this.save().hashCode();
    }
}

