/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.misc.icons;

import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconData;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class IconIcon
extends IconData {
    public static final IconData.Type TYPE = new IconData.Type(VersionUtil.lcResource("icon"), IconIcon::loadIcon, IconIcon::parseIcon);
    private final ResourceLocation location;

    public IconIcon(ResourceLocation location) {
        super(TYPE);
        this.location = location;
    }

    public static IconData ofIcon(ResourceLocation location) {
        return new IconIcon(location.m_246208_("textures/gui/icons/").m_266382_(".png"));
    }

    @Override
    public void render(EasyGuiGraphics gui, int x, int y) {
        gui.blit(this.location, x, y, 0, 0, 16, 16, 16, 16);
    }

    @Override
    protected void saveAdditional(CompoundTag tag) {
        tag.m_128359_("location", this.location.toString());
    }

    @Override
    protected void writeAdditional(JsonObject json) {
        json.addProperty("location", this.location.toString());
    }

    private static IconData loadIcon(CompoundTag tag) {
        return new IconIcon(VersionUtil.parseResource(tag.m_128461_("location")));
    }

    private static IconData parseIcon(JsonObject json) {
        return new IconIcon(VersionUtil.parseResource(GsonHelper.m_13906_((JsonObject)json, (String)"location")));
    }
}

