/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.misc.client.rendering;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.FixedSizeSprite;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.SpriteSource;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.SpriteUtil;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IEasyScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidget;
import io.github.lightman314.lightmanscurrency.client.util.OutlineUtil;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.event.ContainerScreenEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Matrix4f;
import org.joml.Vector4f;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public final class EasyGuiGraphics {
    private static final List<ResourceLocation> debuggedModels = new ArrayList<ResourceLocation>();
    private final GuiGraphics gui;
    public final Font font;
    public final ScreenPosition mousePos;
    public final float partialTicks;
    private final List<ScreenPosition> offsetStack = new ArrayList<ScreenPosition>();
    private ScreenPosition offset = ScreenPosition.ZERO;

    public GuiGraphics getGui() {
        return this.gui;
    }

    public PoseStack getPose() {
        return this.gui.m_280168_();
    }

    public ScreenPosition getOffset() {
        return this.offset;
    }

    public EasyGuiGraphics pushOffsetZero() {
        return this.pushOffset(ScreenPosition.ZERO);
    }

    public EasyGuiGraphics pushOffset(ScreenPosition offset) {
        this.offsetStack.add(0, offset);
        return this.refactorOffset();
    }

    public EasyGuiGraphics pushOffset(AbstractWidget widget) {
        this.offsetStack.add(0, ScreenPosition.of(widget.m_252754_(), widget.m_252907_()));
        return this.refactorOffset();
    }

    public EasyGuiGraphics popOffset() {
        if (!this.offsetStack.isEmpty()) {
            this.offsetStack.remove(0);
        }
        return this.refactorOffset();
    }

    private EasyGuiGraphics refactorOffset() {
        this.offset = !this.offsetStack.isEmpty() ? this.offsetStack.get(0) : ScreenPosition.ZERO;
        return this;
    }

    private EasyGuiGraphics(GuiGraphics gui, Font font, int mouseX, int mouseY, float partialTicks) {
        this.gui = gui;
        this.font = font;
        this.mousePos = ScreenPosition.of(mouseX, mouseY);
        this.partialTicks = partialTicks;
    }

    public static EasyGuiGraphics create(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        return EasyGuiGraphics.create(gui, Minecraft.m_91087_().f_91062_, mouseX, mouseY, partialTicks);
    }

    public static EasyGuiGraphics create(GuiGraphics gui, Font font, int mouseX, int mouseY, float partialTicks) {
        return new EasyGuiGraphics(gui, font, mouseX, mouseY, partialTicks);
    }

    public static EasyGuiGraphics create(ScreenEvent.Render event) {
        return new EasyGuiGraphics(event.getGuiGraphics(), event.getScreen().getMinecraft().f_91062_, event.getMouseX(), event.getMouseY(), event.getPartialTick());
    }

    public static EasyGuiGraphics create(ContainerScreenEvent.Render event) {
        return new EasyGuiGraphics(event.getGuiGraphics(), event.getContainerScreen().getMinecraft().f_91062_, event.getMouseX(), event.getMouseY(), 0.0f);
    }

    public void setColor(float r, float g, float b) {
        this.setColor(r, g, b, 1.0f);
    }

    public void setColor(float r, float g, float b, float a) {
        this.gui.m_280246_(r, g, b, a);
    }

    public void setColor(int color) {
        this.setColor(OutlineUtil.decodeColor(color));
    }

    public void setColor(int color, float alpha) {
        this.setColor(OutlineUtil.decodeColor(color, alpha));
    }

    public void setColor(Vector4f color) {
        this.gui.m_280246_(color.x, color.y, color.z, color.w);
    }

    public void resetColor() {
        this.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void renderNormalBackground(ResourceLocation image, IEasyScreen screen) {
        this.resetColor();
        this.pushOffset(screen.getCorner()).blit(image, 0, 0, 0, 0, screen.getXSize(), screen.getYSize());
        this.popOffset();
    }

    public void renderNormalBackground(ResourceLocation image, IEasyScreen screen, int color) {
        this.setColor(color, 1.0f);
        this.pushOffset(screen.getCorner()).blit(image, 0, 0, 0, 0, screen.getXSize(), screen.getYSize());
        this.resetColor();
        this.popOffset();
    }

    public void renderNormalBackground(IEasyScreen screen) {
        this.resetColor();
        this.pushOffset(screen.getCorner());
        SpriteUtil.GENERIC_BACKGROUND.render(this, 0, 0, screen.getXSize(), screen.getYSize());
        this.popOffset();
    }

    public void renderSlot(IEasyScreen screen, Slot slot) {
        if (slot.m_6659_()) {
            this.renderSlot(screen, ScreenPosition.of(slot.f_40220_, slot.f_40221_));
        }
    }

    public void renderSlot(IEasyScreen screen, int posX, int posY) {
        this.renderSlot(screen, ScreenPosition.of(posX, posY));
    }

    public void renderSlot(IEasyScreen screen, int posX, int posY, FixedSizeSprite type) {
        this.renderSlot(screen, ScreenPosition.of(posX, posY), type);
    }

    public void renderSlot(IEasyScreen screen, ScreenPosition position) {
        this.renderSlot(screen, position, SpriteUtil.EMPTY_SLOT_NORMAL);
    }

    public void renderSlot(IEasyScreen screen, ScreenPosition position, FixedSizeSprite type) {
        this.resetColor();
        this.pushOffset(screen.getCorner());
        type.render(this, position.offset(-1, -1));
        this.popOffset();
    }

    public void blit(ResourceLocation image, int x, int y, int u, int v, int width, int height) {
        this.gui.m_280218_(image, this.offset.x + x, this.offset.y + y, u, v, width, height);
    }

    public void blit(ResourceLocation image, ScreenPosition pos, int u, int v, int width, int height) {
        this.blit(image, pos.x, pos.y, u, v, width, height);
    }

    public void blit(ResourceLocation image, ScreenArea area, int u, int v) {
        this.blit(image, area.pos.x, area.pos.y, u, v, area.width, area.height);
    }

    public void blit(ResourceLocation image, int x, int y, int u, int v, int width, int height, int imageWidth, int imageHeight) {
        this.gui.m_280163_(image, this.offset.x + x, this.offset.y + y, (float)u, (float)v, width, height, imageWidth, imageHeight);
    }

    public void blit(ResourceLocation image, ScreenPosition pos, int u, int v, int width, int height, int imageWidth, int imageHeight) {
        this.blit(image, pos.x, pos.y, u, v, width, height, imageWidth, imageHeight);
    }

    public void blit(ResourceLocation image, ScreenArea area, int u, int v, int imageWidth, int imageHeight) {
        this.blit(image, area.pos.x, area.pos.y, u, v, area.width, area.height, imageWidth, imageHeight);
    }

    public void blitSpriteFadeHoriz(SpriteSource sprite, int x, int y, float percent) {
        int blitWidth = MathUtil.clamp((int)((float)(sprite.width() + 1) * percent), 0, sprite.width());
        this.blit(sprite.texture(), x, y, sprite.u(), sprite.v(), blitWidth, sprite.height(), sprite.textureWidth(), sprite.textureHeight());
    }

    public void blitSpriteFadeHoriz(SpriteSource sprite, ScreenPosition pos, float percent) {
        this.blitSpriteFadeHoriz(sprite, pos.x, pos.y, percent);
    }

    public void renderButtonBG(int x, int y, int width, int height, float alpha, int textureY) {
        this.renderButtonBG(x, y, width, height, alpha, textureY, 0xFFFFFF);
    }

    public void renderButtonBG(int x, int y, int width, int height, float alpha, int textureY, int color) {
        Minecraft minecraft = Minecraft.m_91087_();
        this.setColor(color, alpha);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        this.gui.m_280027_(AbstractWidget.f_93617_, this.offset.x + x, this.offset.y + y, width, height, 20, 4, 200, 20, 0, textureY);
        this.resetColor();
    }

    public void fill(int x, int y, int width, int height, int color) {
        this.gui.m_280509_(this.offset.x + x, this.offset.y + y, this.offset.x + x + width, this.offset.y + y + height, color);
    }

    public void fill(ScreenPosition pos, int width, int height, int color) {
        this.fill(pos.x, pos.y, width, height, color);
    }

    public void fill(ScreenArea area, int color) {
        this.fill(area.x, area.y, area.width, area.height, color);
    }

    public void renderTooltip(Component tooltip) {
        this.pushOffset(this.mousePos).renderTooltip(tooltip, 0, 0);
        this.popOffset();
    }

    public void renderTooltip(Component tooltip, int x, int y) {
        this.gui.m_280557_(this.font, tooltip, this.offset.x + x, this.offset.y + y);
    }

    public void renderComponentTooltip(List<Component> tooltip) {
        this.pushOffset(this.mousePos).renderComponentTooltip(tooltip, 0, 0);
        this.popOffset();
    }

    public void renderComponentTooltip(List<Component> tooltip, int x, int y) {
        if (tooltip.isEmpty()) {
            return;
        }
        this.gui.m_280666_(this.font, tooltip, this.offset.x + x, this.offset.y + y);
    }

    public void renderTooltip(List<FormattedCharSequence> tooltip) {
        this.pushOffset(this.mousePos).renderTooltip(tooltip, 0, 0);
        this.popOffset();
    }

    public void renderTooltip(List<FormattedCharSequence> tooltip, int x, int y) {
        if (tooltip.isEmpty()) {
            return;
        }
        this.gui.m_280245_(this.font, tooltip, this.offset.x + x, this.offset.y + y);
    }

    public void renderTooltip(ItemStack item) {
        this.pushOffset(this.mousePos).renderTooltip(item, 0, 0);
        this.popOffset();
    }

    public void renderTooltip(ItemStack item, int x, int y) {
        this.gui.m_280153_(this.font, item, this.offset.x + x, this.offset.y + y);
    }

    public void drawString(String text, int x, int y, int color) {
        this.gui.m_280056_(this.font, text, this.offset.x + x, this.offset.y + y, color, false);
    }

    public void drawString(String text, ScreenPosition pos, int color) {
        this.drawString(text, pos.x, pos.y, color);
    }

    public void drawString(Component text, int x, int y, int color) {
        this.gui.m_280614_(this.font, text, this.offset.x + x, this.offset.y + y, color, false);
    }

    public void drawString(Component text, ScreenPosition pos, int color) {
        this.drawString(text, pos.x, pos.y, color);
    }

    public void drawString(FormattedCharSequence text, int x, int y, int color) {
        this.gui.m_280649_(this.font, text, this.offset.x + x, this.offset.y + y, color, false);
    }

    public void drawString(FormattedCharSequence text, ScreenPosition pos, int color) {
        this.drawString(text, pos.x, pos.y, color);
    }

    public void drawShadowed(String text, int x, int y, int color) {
        this.gui.m_280056_(this.font, text, this.offset.x + x, this.offset.y + y, color, true);
    }

    public void drawShadowed(String text, ScreenPosition pos, int color) {
        this.drawShadowed(text, pos.x, pos.y, color);
    }

    public void drawShadowed(Component text, int x, int y, int color) {
        this.gui.m_280614_(this.font, text, this.offset.x + x, this.offset.y + y, color, true);
    }

    public void drawShadowed(Component text, ScreenPosition pos, int color) {
        this.drawShadowed(text, pos.x, pos.y, color);
    }

    public void drawShadowed(FormattedCharSequence text, int x, int y, int color) {
        this.gui.m_280649_(this.font, text, this.offset.x + x, this.offset.y + y, color, true);
    }

    public void drawShadowed(FormattedCharSequence text, ScreenPosition pos, int color) {
        this.drawShadowed(text, pos.x, pos.y, color);
    }

    public void drawWordWrap(String text, int x, int y, int columnWidth, int color) {
        this.gui.m_280554_(this.font, (FormattedText)EasyText.literal(text), this.offset.x + x, this.offset.y + y, columnWidth, color);
    }

    public void drawWordWrap(Component text, int x, int y, int columnWidth, int color) {
        this.gui.m_280554_(this.font, (FormattedText)text, this.offset.x + x, this.offset.y + y, columnWidth, color);
    }

    public void drawScrollingString(String text, int x, int y, int width, int height, int color) {
        this.drawScrollingString((Component)EasyText.literal(text), x, y, width, height, color);
    }

    public void drawScrollingString(Component text, int x, int y, int width, int height, int color) {
        this.drawScrollingString(text, ScreenArea.of(x, y, width, height), color);
    }

    public void drawScrollingString(String text, ScreenArea area, int color) {
        this.drawScrollingString((Component)EasyText.literal(text), area, color);
    }

    public void drawScrollingString(Component text, ScreenArea area, int color) {
        area = area.offsetPosition(this.offset);
        EasyWidget.drawScrollingString(this.gui, this.font, text, area.x, area.y, area.x + area.width, area.y + area.height, color);
    }

    public void renderItem(ItemStack item, int x, int y) {
        this.renderItem(item, x, y, null);
    }

    public void renderItem(ItemStack item, ScreenPosition pos) {
        this.renderItem(item, pos.x, pos.y);
    }

    public void renderItem(ItemStack item, ScreenPosition pos, @Nullable String countTextOverride) {
        this.renderItem(item, pos.x, pos.y, countTextOverride);
    }

    public void renderItem(ItemStack item, int x, int y, @Nullable String countTextOverride) {
        this.resetColor();
        this.gui.m_280480_(item, this.offset.x + x, this.offset.y + y);
        this.gui.m_280302_(this.font, item, this.offset.x + x, this.offset.y + y, countTextOverride);
    }

    public void renderScaledItem(ItemStack item, ScreenPosition pos, float scale) {
        this.renderScaledItem(item, pos.x, pos.y, scale);
    }

    public void renderScaledItem(ItemStack item, int x, int y, float scale) {
        this.resetColor();
        Minecraft minecraft = Minecraft.m_91087_();
        BakedModel bakedmodel = minecraft.m_91291_().m_174264_(item, null, null, 0);
        PoseStack pose = this.getPose();
        pose.m_85836_();
        pose.m_252880_((float)(this.offset.x + x), (float)(this.offset.y + y), 150.0f);
        try {
            boolean flag;
            pose.m_85841_(scale, scale, scale);
            pose.m_252880_(8.0f, 8.0f, 0.0f);
            pose.m_252931_(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
            pose.m_85841_(16.0f, 16.0f, 16.0f);
            boolean bl = flag = !bakedmodel.m_7547_();
            if (flag) {
                Lighting.m_84930_();
            }
            minecraft.m_91291_().m_115143_(item, ItemDisplayContext.GUI, false, pose, (MultiBufferSource)this.gui.m_280091_(), 0xF000F0, OverlayTexture.f_118083_, bakedmodel);
            this.gui.m_280262_();
            if (flag) {
                Lighting.m_84931_();
            }
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Rendering item");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Item being rendered");
            crashreportcategory.m_128165_("Item Type", () -> String.valueOf(item.m_41720_()));
            crashreportcategory.m_128165_("Registry Name", () -> String.valueOf(ForgeRegistries.ITEMS.getKey((Object)item.m_41720_())));
            crashreportcategory.m_128165_("Item Damage", () -> String.valueOf(item.m_41773_()));
            crashreportcategory.m_128165_("Item NBT", () -> String.valueOf(item.m_41783_()));
            crashreportcategory.m_128165_("Item Foil", () -> String.valueOf(item.m_41790_()));
            throw new ReportedException(crashreport);
        }
        pose.m_85849_();
    }

    public void renderItemModel(ResourceLocation model, int x, int y) {
        this.renderItemModel(model, x, y, new ItemStack((ItemLike)Items.f_42127_));
    }

    public void renderItemModel(ResourceLocation model, int x, int y, ItemStack fallback) {
        this.resetColor();
        Minecraft minecraft = Minecraft.m_91087_();
        BakedModel bakedmodel = minecraft.m_91304_().getModel(model);
        if (bakedmodel == minecraft.m_91304_().m_119409_()) {
            if (!debuggedModels.contains(model)) {
                LightmansCurrency.LogWarning("Missing model for " + model + ". Rendering fallback item.");
                debuggedModels.add(model);
            }
            this.renderItem(fallback, x, y);
            return;
        }
        PoseStack pose = this.getPose();
        pose.m_85836_();
        pose.m_252880_((float)(this.offset.x + x + 8), (float)(this.offset.y + y + 8), 150.0f);
        try {
            boolean flag;
            pose.m_252931_(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
            pose.m_85841_(16.0f, 16.0f, 16.0f);
            boolean bl = flag = !bakedmodel.m_7547_();
            if (flag) {
                Lighting.m_84930_();
            }
            minecraft.m_91291_().m_115143_(new ItemStack((ItemLike)ModItems.COIN_COPPER.get()), ItemDisplayContext.GUI, false, pose, (MultiBufferSource)this.gui.m_280091_(), 0xF000F0, OverlayTexture.f_118083_, bakedmodel);
            this.gui.m_280262_();
            if (flag) {
                Lighting.m_84931_();
            }
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Rendering item");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Model being rendered");
            crashreportcategory.m_128165_("Model ID", () -> String.valueOf(model));
            throw new ReportedException(crashreport);
        }
        pose.m_85849_();
    }

    public void renderSlotBackground(Pair<ResourceLocation, ResourceLocation> background, ScreenPosition pos) {
        this.renderSlotBackground(background, pos.x, pos.y);
    }

    public void renderSlotBackground(Pair<ResourceLocation, ResourceLocation> background, int x, int y) {
        if (background == null) {
            return;
        }
        TextureAtlasSprite textureatlassprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_((ResourceLocation)background.getFirst()).apply((ResourceLocation)background.getSecond());
        this.gui.m_280159_(this.offset.x + x, this.offset.y + y, 0, 16, 16, textureatlassprite);
    }

    public void renderSlotHighlight(int x, int y) {
        this.gui.m_285978_(RenderType.m_286086_(), this.offset.x + x, this.offset.y + y, this.offset.x + x + 16, this.offset.y + y + 16, -2130706433, -2130706433, 0);
    }

    public void renderSlotHighlight(ScreenPosition pos) {
        this.renderSlotHighlight(pos.x, pos.y);
    }

    public void enableScissor(int x, int y, int width, int height) {
        this.enableScissor(ScreenArea.of(x, y, width, height));
    }

    public void enableScissor(ScreenArea area) {
        area = area.offsetPosition(this.offset);
        this.gui.m_280588_(area.x, area.y, area.x + area.width, area.y + area.height);
    }

    public void disableScissor() {
        this.gui.m_280618_();
    }

    public EasyGuiGraphics pushPose() {
        this.gui.m_280168_().m_85836_();
        return this;
    }

    public void TranslateToForeground() {
        this.gui.m_280168_().m_85837_(0.0, 0.0, 250.0);
    }

    public void popPose() {
        this.gui.m_280168_().m_85849_();
    }
}

