/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.filter;

import io.github.lightman314.lightmanscurrency.api.filter.IItemTradeFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class FilterAPI {
    private static final List<Function<ItemStack, IItemTradeFilter>> filterProviders = new ArrayList<Function<ItemStack, IItemTradeFilter>>();

    public static void registerFilterProvider(Function<ItemStack, IItemTradeFilter> provider) {
        if (filterProviders.contains(provider)) {
            return;
        }
        filterProviders.add(provider);
    }

    @Nullable
    public static IItemTradeFilter tryGetFilter(ItemStack stack) {
        for (Function<ItemStack, IItemTradeFilter> provider : filterProviders) {
            IItemTradeFilter result = provider.apply(stack);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static boolean itemHasFilter(ItemStack stack) {
        IItemTradeFilter filter = FilterAPI.tryGetFilter(stack);
        return filter != null && filter.getFilter(stack) != null;
    }

    static {
        filterProviders.add(s -> {
            Item patt648$temp = s.m_41720_();
            if (patt648$temp instanceof IItemTradeFilter) {
                IItemTradeFilter filter = (IItemTradeFilter)patt648$temp;
                return filter;
            }
            return null;
        });
    }
}

