/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.nanny;

import dev.qther.nanny.Config;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="nanny")
public class NaNny {
    private static final Logger LOGGER = LogManager.getLogger();

    public NaNny() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SPEC, "nanny-server.toml");
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent e) {
        LOGGER.info("Scouting a NaNny...");
    }

    @SubscribeEvent
    public void onServerStarted(ServerStartedEvent e) {
        LOGGER.info("NaNny hired!");
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent e) {
        float dmg = e.getAmount();
        LivingEntity le = e.getEntity();
        if (Float.isNaN(dmg)) {
            e.setCanceled(true);
            this.rectify(le);
            this.warn("A hurt event tried to deal NaN damage to " + this.getName(le) + "! Source: " + e.getSource());
            return;
        }
    }

    @SubscribeEvent
    public void onLivingDamage(LivingDamageEvent e) {
        LivingEntity le = e.getEntity();
        float dmg = e.getAmount();
        if (Float.isNaN(dmg)) {
            e.setCanceled(true);
            this.rectify(le);
            this.warn("A damage event tried to deal NaN damage to " + this.getName(le) + "! Source: " + e.getSource());
            return;
        }
    }

    @SubscribeEvent
    public void onAttackEntity(LivingAttackEvent e) {
        LivingEntity le = e.getEntity();
        float dmg = e.getAmount();
        if (Float.isNaN(dmg)) {
            e.setCanceled(true);
            this.rectify(le);
            this.warn("A attack event tried to deal NaN damage to " + this.getName(le) + "! Source: " + e.getSource());
            return;
        }
    }

    @SubscribeEvent
    public void onLivingHeal(LivingHealEvent e) {
        float amount = e.getAmount();
        LivingEntity le = e.getEntity();
        if (Float.isNaN(amount)) {
            e.setCanceled(true);
            this.warn("A heal event tried to heal NaN health to " + this.getName(le) + "!");
            return;
        }
        if (Float.isNaN(le.m_21223_())) {
            e.setCanceled(true);
            this.rectify(le);
            this.warn("A heal event set " + le.m_7755_().getString() + "'s health to NaN!");
            return;
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent e) {
        LivingEntity le = e.getEntity();
        float hp = le.m_21223_();
        if (Float.isNaN(hp)) {
            e.setCanceled(true);
            this.rectify(le);
            this.warn("A death event set " + this.getName(le) + "'s health to NaN! Source: " + e.getSource());
            return;
        }
    }

    private void warn(String msg) {
        if (((Boolean)Config.log.get()).booleanValue()) {
            LOGGER.warn(msg);
        }
    }

    private void rectify(LivingEntity le) {
        if (((Boolean)Config.doHeal.get()).booleanValue()) {
            le.m_21153_(le.m_21233_() * ((Double)Config.health.get()).floatValue());
        }
        le.m_7911_(0.0f);
    }

    private String getName(LivingEntity e) {
        return e.m_7755_().getString();
    }
}

