/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.network;

import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.puzzleslib.api.network.v2.MessageV2;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;

public class S2CMutantLevelParticlesMessage
implements MessageV2<S2CMutantLevelParticlesMessage> {
    private ParticleOptions particleData;
    private double posX;
    private double posY;
    private double posZ;
    private double speedX;
    private double speedY;
    private double speedZ;
    private int amount;

    public S2CMutantLevelParticlesMessage() {
    }

    public S2CMutantLevelParticlesMessage(ParticleOptions particleData, double posX, double posY, double posZ, double speedX, double speedY, double speedZ, int amount) {
        this.particleData = particleData;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.speedX = speedX;
        this.speedY = speedY;
        this.speedZ = speedZ;
        this.amount = amount;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130130_(BuiltInRegistries.f_257034_.m_7447_((Object)this.particleData.m_6012_()));
        this.particleData.m_7711_(buf);
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
        buf.writeDouble(this.speedX);
        buf.writeDouble(this.speedY);
        buf.writeDouble(this.speedZ);
        buf.m_130130_(this.amount);
    }

    public void read(FriendlyByteBuf buf) {
        ParticleType particletype = (ParticleType)BuiltInRegistries.f_257034_.m_7942_(buf.m_130242_());
        this.particleData = this.readParticle(buf, particletype);
        this.posX = buf.readDouble();
        this.posY = buf.readDouble();
        this.posZ = buf.readDouble();
        this.speedX = buf.readDouble();
        this.speedY = buf.readDouble();
        this.speedZ = buf.readDouble();
        this.amount = buf.m_130242_();
    }

    private <T extends ParticleOptions> T readParticle(FriendlyByteBuf packetBuffer, ParticleType<T> particleType) {
        return (T)particleType.m_123743_().m_6507_(particleType, packetBuffer);
    }

    public MessageV2.MessageHandler<S2CMutantLevelParticlesMessage> makeHandler() {
        return new MessageV2.MessageHandler<S2CMutantLevelParticlesMessage>(){

            public void handle(S2CMutantLevelParticlesMessage message, Player player, Object gameInstance) {
                ClientLevel level = ((Minecraft)gameInstance).f_91073_;
                if (message.particleData == ModRegistry.ENDERSOUL_PARTICLE_TYPE.get()) {
                    for (int i = 0; i < message.amount; ++i) {
                        float f = (level.f_46441_.m_188501_() - 0.5f) * 1.8f;
                        float f1 = (level.f_46441_.m_188501_() - 0.5f) * 1.8f;
                        float f2 = (level.f_46441_.m_188501_() - 0.5f) * 1.8f;
                        double tempX = message.posX + (double)(level.f_46441_.m_188501_() - 0.5f) * message.speedX;
                        double tempY = message.posY + (double)(level.f_46441_.m_188501_() - 0.5f) * message.speedY + 0.5;
                        double tempZ = message.posZ + (double)(level.f_46441_.m_188501_() - 0.5f) * message.speedZ;
                        level.m_6485_((ParticleOptions)ModRegistry.ENDERSOUL_PARTICLE_TYPE.get(), true, tempX, tempY, tempZ, (double)f, (double)f1, (double)f2);
                    }
                } else {
                    for (int i = 0; i < message.amount; ++i) {
                        double d0 = level.f_46441_.m_188583_() * 0.02;
                        double d1 = level.f_46441_.m_188583_() * 0.02;
                        double d2 = level.f_46441_.m_188583_() * 0.02;
                        level.m_7106_(message.particleData, message.posX, message.posY, message.posZ, d0, d1, d2);
                    }
                }
            }
        };
    }
}

