/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fuzs.mutantmonsters.client.init.ClientModRegistry;
import fuzs.mutantmonsters.client.model.CreeperMinionModel;
import fuzs.mutantmonsters.client.renderer.MutantRenderTypes;
import fuzs.mutantmonsters.client.renderer.entity.CreeperMinionRenderer;
import fuzs.mutantmonsters.client.renderer.entity.layers.CreeperChargeLayer;
import fuzs.mutantmonsters.init.ModRegistry;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;

public class CreeperMinionShoulderLayer<T extends Player>
extends RenderLayer<T, PlayerModel<T>> {
    private final CreeperMinionModel model;
    private final CreeperMinionModel chargedModel;

    public CreeperMinionShoulderLayer(RenderLayerParent<T, PlayerModel<T>> entityRenderer, EntityModelSet entityModelSet) {
        super(entityRenderer);
        this.model = new CreeperMinionModel(entityModelSet.m_171103_(ClientModRegistry.CREEPER_MINION_SHOULDER));
        this.chargedModel = new CreeperMinionModel(entityModelSet.m_171103_(ClientModRegistry.CREEPER_MINION_SHOULDER_ARMOR));
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        this.renderCreeperMinion(matrixStackIn, bufferIn, packedLightIn, entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, true);
        this.renderCreeperMinion(matrixStackIn, bufferIn, packedLightIn, entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, false);
    }

    private void renderCreeperMinion(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, T livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, boolean leftShoulderIn) {
        CompoundTag compoundnbt = leftShoulderIn ? livingEntity.m_36331_() : livingEntity.m_36332_();
        EntityType.m_20632_((String)compoundnbt.m_128461_("id")).filter(((EntityType)ModRegistry.CREEPER_MINION_ENTITY_TYPE.get())::equals).ifPresent(entityType -> {
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(leftShoulderIn ? (double)0.42f : (double)-0.42f, livingEntity.m_6047_() ? (double)-0.55f : -0.75, 0.0);
            matrixStackIn.m_85841_(0.5f, 0.5f, 0.5f);
            VertexConsumer ivertexbuilder = bufferIn.m_6299_(this.model.m_103119_(CreeperMinionRenderer.TEXTURE));
            this.model.setupAnim(null, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            this.model.m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            if (compoundnbt.m_128471_("Powered")) {
                VertexConsumer ivertexbuilder1 = bufferIn.m_6299_(MutantRenderTypes.m_110436_(CreeperChargeLayer.LIGHTNING_TEXTURE, ageInTicks * 0.01f, ageInTicks * 0.01f));
                this.chargedModel.setupAnim(null, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                this.chargedModel.m_7695_(matrixStackIn, ivertexbuilder1, packedLightIn, OverlayTexture.f_118083_, 0.5f, 0.5f, 0.5f, 1.0f);
            }
            matrixStackIn.m_85849_();
        });
    }
}

