/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.auto_repair_kit.kits;

import com.robertx22.auto_repair_kit.compat.CurioCompat;
import com.robertx22.auto_repair_kit.kits.RepairEventData;
import com.robertx22.auto_repair_kit.kits.RepairKitItem;
import com.robertx22.auto_repair_kit.kits.RepairKitTier;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.ModList;

public class RepairUTIL {
    public static void tryRepair(Player p) {
        Item item;
        ItemStack kit = RepairUTIL.getBestKit(p);
        if (kit != null && (item = kit.m_41720_()) instanceof RepairKitItem) {
            RepairKitItem rep = (RepairKitItem)item;
            List<ItemStack> gears = RepairUTIL.getGearToRepair(p);
            RepairEventData data = new RepairEventData(kit);
            if (data.charges > 0) {
                for (ItemStack gear : gears) {
                    RepairUTIL.tryRepair(gear, data);
                }
                if (ModList.get().isLoaded("curios")) {
                    CurioCompat.tryRepair(p, data);
                }
            }
        }
    }

    public static void tryRepair(ItemStack gear, RepairEventData data) {
        Item item;
        ItemStack kit = data.kit;
        if (kit != null && (item = kit.m_41720_()) instanceof RepairKitItem) {
            RepairKitItem rep = (RepairKitItem)item;
            if (gear.m_41768_() && data.charges > 0) {
                int torepair = gear.m_41773_();
                if (torepair > data.charges) {
                    torepair = data.charges;
                }
                if (torepair > rep.tier.getTotalPerAction()) {
                    torepair = rep.tier.getTotalPerAction();
                }
                gear.m_41721_(gear.m_41773_() - torepair);
                data.charges -= torepair;
                RepairUTIL.addCharges(kit, -torepair, rep.tier);
            }
        }
    }

    public static List<ItemStack> getGearToRepair(Player p) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            list.add(p.m_6844_(slot));
        }
        return list;
    }

    public static ItemStack getBestKit(Player p) {
        ItemStack kit = null;
        for (int i = 0; i < p.m_150109_().m_6643_(); ++i) {
            ItemStack stack = p.m_150109_().m_8020_(i);
            Item item = stack.m_41720_();
            if (!(item instanceof RepairKitItem)) continue;
            RepairKitItem r = (RepairKitItem)item;
            if (kit == null) {
                kit = stack;
                continue;
            }
            if (RepairUTIL.getCharges(stack) <= RepairUTIL.getCharges(kit)) continue;
            kit = stack;
        }
        return kit;
    }

    public static void chargeKit(ItemStack stack, int amount) {
    }

    public static int getCharges(ItemStack stack) {
        return stack.m_41784_().m_128451_("charges");
    }

    public static void addCharges(ItemStack stack, int amount, RepairKitTier tier) {
        int after = RepairUTIL.getCharges(stack) + amount;
        if (after < 0) {
            after = 0;
        }
        if (after > tier.getMax()) {
            after = tier.getMax();
        }
        float dura = 1.0f - (float)after / (float)tier.getMax();
        int dmg = (int)((float)stack.m_41776_() * dura);
        if (dmg >= stack.m_41776_()) {
            dmg = stack.m_41776_() - 1;
        }
        stack.m_41784_().m_128405_("charges", after);
        stack.m_41721_(dmg);
    }
}

