/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.auto_repair_kit.configs;

import com.robertx22.auto_repair_kit.kits.RepairKitTier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class KitConfig {
    public static final ForgeConfigSpec SPEC;
    public static final KitConfig KIT_CONFIG;
    public HashMap<RepairKitTier, ForgeConfigSpec.IntValue> maxCharges = new HashMap();
    public HashMap<RepairKitTier, ForgeConfigSpec.IntValue> maxPerAction = new HashMap();
    public ForgeConfigSpec.ConfigValue<List<? extends String>> CHARGE_MATS;
    public ForgeConfigSpec.IntValue REPAIR_INTERVAL;
    HashMap<Item, Integer> chargeMaterials = new HashMap();

    public static KitConfig get() {
        return KIT_CONFIG;
    }

    public HashMap<Item, Integer> getChargeMaterialMap() {
        if (this.chargeMaterials.isEmpty()) {
            for (String s : (List)this.CHARGE_MATS.get()) {
                try {
                    String[] split = s.split(";");
                    ResourceLocation id = new ResourceLocation(split[0]);
                    int n = Integer.parseInt(split[1]);
                    Item theitem = (Item)BuiltInRegistries.f_257033_.m_7745_(id);
                    this.chargeMaterials.put(theitem, n);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return this.chargeMaterials;
    }

    public int getChargeMaterial(Item item) {
        this.getChargeMaterialMap();
        return this.chargeMaterials.getOrDefault(item, 0);
    }

    KitConfig(ForgeConfigSpec.Builder b) {
        b.comment("Auto Repair Kits Configs").push("general");
        this.REPAIR_INTERVAL = b.comment("Example, at default setting of 100 ticks, (1 second is 20 ticks), the repair kits will automatically repair player's gear every 5 seconds").defineInRange("repair_interval", 100, 1, 5000);
        for (RepairKitTier tier : RepairKitTier.values()) {
            b.push(tier.name());
            ForgeConfigSpec.IntValue max = b.comment("The amount the Kit can be charged.").defineInRange("max_charges", tier.defaults.maxCharges, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.IntValue action = b.comment("The total amount the kit can repair at once every 5s. (This is per each item)").defineInRange("max_repair_per_item_every_5s", tier.defaults.maxRepairedAtOnceTotal, 0, Integer.MAX_VALUE);
            this.maxCharges.put(tier, max);
            this.maxPerAction.put(tier, action);
            b.pop();
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add("minecraft:leather;10");
        list.add("minecraft:iron_ingot;25");
        list.add("minecraft:gold_ingot;50");
        list.add("minecraft:diamond;250");
        list.add("minecraft:netherite_ingot;500");
        this.CHARGE_MATS = b.comment("What items can be used to charge the repair kits. Usage: minecraft:diamond;50  to make diamonds charge the kit for 50 durability").defineList("charge_material_items", list, x -> {
            String str = (String)x;
            return str.split(";").length == 2;
        });
        b.pop();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(KitConfig::new);
        SPEC = (ForgeConfigSpec)specPair.getRight();
        KIT_CONFIG = (KitConfig)specPair.getLeft();
    }
}

