/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.colored_water.cauldrons.util;

import com.cozary.colored_water.cauldrons.block.base.AbstractLeveledCauldronBlock;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ItemUsage {
    public static ItemStack exchangeStack(ItemStack inputStack, Player player, ItemStack outputStack, boolean creativeOverride) {
        boolean bl = player.m_150110_().f_35937_;
        if (creativeOverride && bl) {
            if (!player.m_150109_().m_36063_(outputStack)) {
                player.m_150109_().m_36054_(outputStack);
            }
            return inputStack;
        }
        if (!bl) {
            inputStack.m_41774_(1);
        }
        if (inputStack.m_41619_()) {
            return outputStack;
        }
        if (!player.m_150109_().m_36054_(outputStack)) {
            player.m_36176_(outputStack, false);
        }
        return inputStack;
    }

    public static ItemStack exchangeStack(ItemStack inputStack, Player player, ItemStack outputStack) {
        return ItemUsage.exchangeStack(inputStack, player, outputStack, true);
    }

    static boolean canIncrementFluidLevel(BlockState state, int amount) {
        return ItemUsage.canSetFluidLevel(state, ItemUsage.getFluidLevel(state) + amount);
    }

    public static boolean canIncrementFluidLevel(BlockState state) {
        return ItemUsage.canIncrementFluidLevel(state, 1);
    }

    static boolean canSetFluidLevel(BlockState state, int level) {
        int maxLevel = ItemUsage.getMaxFluidLevel(state);
        int actualLevel = Math.max(0, Math.min(level, maxLevel));
        return maxLevel != -1 && level == actualLevel && ItemUsage.getFluidLevel(state) != actualLevel;
    }

    static int getFluidLevel(BlockState state) {
        Block block = state.m_60734_();
        if (block instanceof AbstractLeveledCauldronBlock) {
            AbstractLeveledCauldronBlock block2 = (AbstractLeveledCauldronBlock)block;
            return AbstractLeveledCauldronBlock.getFluidLevel(state);
        }
        if (state.m_60713_(Blocks.f_152477_)) {
            return 1;
        }
        if (state.m_60734_() instanceof LayeredCauldronBlock) {
            return (Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_);
        }
        if (state.m_60713_(Blocks.f_50256_)) {
            return 0;
        }
        return -1;
    }

    static int getMaxFluidLevel(BlockState state) {
        Block block = state.m_60734_();
        if (block instanceof AbstractLeveledCauldronBlock) {
            AbstractLeveledCauldronBlock block2 = (AbstractLeveledCauldronBlock)block;
            return AbstractLeveledCauldronBlock.getMaxLevel();
        }
        if (state.m_60713_(Blocks.f_152477_)) {
            return 1;
        }
        if (state.m_60734_() instanceof LayeredCauldronBlock) {
            return 3;
        }
        if (state.m_60713_(Blocks.f_50256_)) {
            return 0;
        }
        return -1;
    }
}

