/*
 * Decompiled with CFR 0.152.
 */
package net.poe.entityfishingdrops.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.minecraftforge.fml.loading.FMLPaths;
import net.poe.entityfishingdrops.Entityfishingdrops;

public class ReadmeGenerator {
    public static void generateReadme() {
        File configDir = new File(FMLPaths.CONFIGDIR.get().toFile(), "EntityFishingDrops");
        File readmeFile = new File(configDir, "README.txt");
        try (FileWriter writer = new FileWriter(readmeFile);){
            writer.write(ReadmeGenerator.getReadmeContent());
            Entityfishingdrops.LOGGER.info("Generated README.txt file");
        }
        catch (IOException e) {
            Entityfishingdrops.LOGGER.error("Failed to generate README.txt", (Throwable)e);
        }
    }

    private static String getReadmeContent() {
        return "================================================================================\n                        ENTITY FISHING DROPS MOD\n                           Complete Guide\n================================================================================\n\nOVERVIEW:\nThis mod allows server administrators to configure custom drops, commands, and\neffects that trigger when players catch fish or other fishing items. Perfect\nfor adding rewards, events, and custom fishing mechanics to your server.\n\nThe mod uses a clean JSON format that only includes the fields you actually need,\nmaking configuration files easier to read and maintain.\n\n================================================================================\n                            FOLDER STRUCTURE\n================================================================================\n\nconfig/EntityFishingDrops/\n\u251c\u2500\u2500 README.txt (this file)\n\u251c\u2500\u2500 Active_Events.json (tracks enabled events)\n\u251c\u2500\u2500 Normal Drops/\n\u2502   \u251c\u2500\u2500 Global_Fishing_Drops.json (always active global drops)\n\u2502   \u251c\u2500\u2500 Global_Fishing_Drops.example (documentation)\n\u2502   \u251c\u2500\u2500 Custom_Global_File.json (your custom global files)\n\u2502   \u2514\u2500\u2500 Drops/\n\u2502       \u251c\u2500\u2500 minecraft_cod.json (item-specific drops)\n\u2502       \u2514\u2500\u2500 minecraft_salmon.json\n\u2514\u2500\u2500 Event Drops/\n    \u251c\u2500\u2500 Easter/\n    \u2502   \u251c\u2500\u2500 Global_Easter_Drops.json (easter global drops)\n    \u2502   \u2514\u2500\u2500 Drops/\n    \u2502       \u2514\u2500\u2500 minecraft_salmon.json (easter item drops)\n    \u251c\u2500\u2500 Winter/\n    \u251c\u2500\u2500 Summer/\n    \u251c\u2500\u2500 Halloween/\n    \u2514\u2500\u2500 Christmas/\n\n================================================================================\n                              COMMANDS\n================================================================================\n\n/fishingdrops reload\n  - Reloads all configuration files\n  - Use after making changes to JSON files\n  - Requires operator permissions\n\n/fishingdrops event <event_name> <true/false>\n  - Enable/disable fishing events\n  - Example: /fishingdrops event Winter true\n  - Available events: Easter, Winter, Summer, Halloween, Christmas\n  - Loads all JSON files from Event Drops/<event_name>/ folder\n  - Sends notification to all online players\n  - Events persist through server restarts\n\n================================================================================\n                         CONFIGURATION FIELDS\n================================================================================\n\nThe mod uses a clean JSON format - only fields you specify will appear in the\ngenerated JSON files. All fields are optional unless otherwise noted.\n\nCORE FIELDS:\n- catchId: What item must be caught to trigger this entry\n  - If specified: only triggers when catching this item\n  - If omitted: triggers on ANY fishing catch\n- itemId: What item to drop\n- dropChance: Percentage chance for drop to occur (0-100)\n- minAmount: Minimum number of items to drop\n- maxAmount: Maximum number of items to drop\n- nbtData: Custom NBT data for the dropped item\n\nCOMMAND FIELDS:\n- command: Command to run on fishing catch (global trigger)\n- commandChance: Percentage chance for command to execute (0-100)\n- commandCooldown: Cooldown in seconds before command can run again\n- dropCommand: Command to run when itemId actually drops\n- dropCommandChance: Percentage chance for dropCommand to execute\n- dropCommandCooldown: Cooldown in seconds for dropCommand\n\nCONDITION FIELDS:\n- requiredDimensions: List of dimensions where this works\n  Example: [\"minecraft:overworld\", \"minecraft:nether\"]\n- requiredBiomes: List of biomes where this works\n  Example: [\"minecraft:ocean\", \"minecraft:river\"]\n- requiredWeather: Weather condition required\n  Options: \"clear\", \"rain\", \"thunder\"\n- requiredTimeOfDay: Time of day required\n  Options: \"day\", \"night\"\n\nEXTRA DROP FIELDS:\n- extraDropChance: Chance for bonus items (0-100)\n- extraAmountMin: Minimum bonus items\n- extraAmountMax: Maximum bonus items\n\nOTHER FIELDS:\n- comment: Description for your reference (not used by mod)\n\n================================================================================\n                           COMMAND PLACEHOLDERS\n================================================================================\n\nUse these placeholders in your commands:\n- {player} - Player's username\n- {x} - Player's X coordinate\n- {y} - Player's Y coordinate\n- {z} - Player's Z coordinate\n- {world} - World/dimension name\n- {biome} - Current biome\n\nExamples:\n- \"give {player} minecraft:diamond 1\"\n- \"tellraw {player} {\"text\":\"You're at {x}, {y}, {z}!\",\"color\":\"green\"}\"\n- \"effect give {player} minecraft:luck 60 1\"\n\n================================================================================\n                              EXAMPLES\n================================================================================\n\nGLOBAL COMMAND ONLY (triggers on any catch):\n{\n  \"command\": \"effect give {player} minecraft:luck 30 0\",\n  \"commandChance\": 10.0,\n  \"commandCooldown\": 300,\n  \"comment\": \"10% chance to give luck effect on any fishing catch\"\n}\n\nGLOBAL DROP (drops on any catch):\n{\n  \"itemId\": \"minecraft:experience_bottle\",\n  \"dropChance\": 5.0,\n  \"minAmount\": 1,\n  \"maxAmount\": 1,\n  \"dropCommand\": \"tellraw {player} {\"text\":\"Bonus XP bottle!\",\"color\":\"green\"}\",\n  \"dropCommandChance\": 100.0,\n  \"comment\": \"5% chance for XP bottle on any fishing catch\"\n}\n\nITEM-SPECIFIC DROP (only when catching cod):\n{\n  \"catchId\": \"minecraft:cod\",\n  \"itemId\": \"minecraft:gold_nugget\",\n  \"dropChance\": 25.0,\n  \"minAmount\": 1,\n  \"maxAmount\": 3,\n  \"dropCommand\": \"tellraw {player} {\"text\":\"Gold found in cod!\",\"color\":\"gold\"}\",\n  \"dropCommandChance\": 100.0,\n  \"comment\": \"25% chance for gold when catching cod\"\n}\n\nCOMBINED GLOBAL + SPECIFIC (global command + specific drop):\n{\n  \"catchId\": \"minecraft:salmon\",\n  \"command\": \"effect give {player} minecraft:regeneration 10 0\",\n  \"commandChance\": 100.0,\n  \"commandCooldown\": 60,\n  \"itemId\": \"minecraft:iron_nugget\",\n  \"dropChance\": 15.0,\n  \"minAmount\": 1,\n  \"maxAmount\": 2,\n  \"dropCommand\": \"tellraw {player} {\"text\":\"Iron from salmon!\",\"color\":\"gray\"}\",\n  \"dropCommandChance\": 100.0,\n  \"comment\": \"Always gives regen on any catch, 15% iron when catching salmon\"\n}\n\nRARE DROP WITH CONDITIONS:\n{\n  \"catchId\": \"minecraft:salmon\",\n  \"itemId\": \"minecraft:diamond\",\n  \"dropChance\": 5.0,\n  \"minAmount\": 1,\n  \"maxAmount\": 1,\n  \"nbtData\": \"{display:{Name:'{\"text\":\"Lucky Diamond\",\"color\":\"aqua\"}'}}\",\n  \"dropCommand\": \"tellraw @a {\"text\":\"{player} found a Lucky Diamond!\",\"color\":\"aqua\"}\",\n  \"dropCommandChance\": 100.0,\n  \"requiredWeather\": \"rain\",\n  \"requiredTimeOfDay\": \"night\",\n  \"comment\": \"Rare diamond only during rain at night\"\n}\n\nMODDED ITEM SUPPORT:\n{\n  \"catchId\": \"minecraft:cod\",\n  \"itemId\": \"thermal:silver_ingot\",\n  \"dropChance\": 15.0,\n  \"minAmount\": 1,\n  \"maxAmount\": 2,\n  \"comment\": \"Works with any modded items\"\n}\n\nCLEAN MINIMAL EXAMPLE (only necessary fields):\n{\n  \"itemId\": \"minecraft:emerald\",\n  \"dropChance\": 2.0,\n  \"comment\": \"Simple 2% emerald drop\"\n}\n\n================================================================================\n                            ACTIVE EVENTS\n================================================================================\n\nEvents allow you to create seasonal or special fishing rewards:\n\nAVAILABLE EVENTS:\n- Easter: Spring-themed rewards\n- Winter: Cold weather bonuses\n- Summer: Warm weather rewards\n- Halloween: Spooky seasonal drops\n- Christmas: Holiday celebration items\n\nHOW TO USE EVENTS:\n1. Create event folder: Event Drops/Halloween/\n2. Add JSON files with special drops\n3. Enable with: /fishingdrops event Halloween true\n4. Event stays active until disabled\n5. Active events are saved in Active_Events.json\n\nWhen events are active:\n- Normal Drops are ALWAYS loaded\n- Event Drops are ADDED to normal drops\n- Players get more rewards during events\n- Multiple events can be active simultaneously\n\n================================================================================\n                            BEST PRACTICES\n================================================================================\n\nORGANIZATION:\n- Use descriptive file names (minecraft_cod.json, rare_drops.json)\n- Group related drops in same files\n- Use comments to document your configurations\n- Keep Global_Fishing_Drops.json for server-wide effects\n- Only include fields you actually need (cleaner JSON)\n\nBALANCING:\n- Start with low drop chances (1-10%) for rare items\n- Use cooldowns on powerful commands\n- Test with dropChance: 100.0 during development\n- Consider server economy when adding valuable drops\n\nPERFORMANCE:\n- Avoid too many complex conditions\n- Use reasonable cooldowns on commands\n- Don't create hundreds of drop entries\n- Group similar drops in single files\n\nPLAYER EXPERIENCE:\n- Use tellraw commands to notify players of special drops\n- Create themed events for holidays\n- Balance rewards with server progression\n- Provide variety in drop types and commands\n\nJSON FORMATTING:\n- Only include fields you need (mod ignores null/default values)\n- Use proper JSON syntax validation\n- Keep comments descriptive but concise\n- Organize entries logically within files\n\n================================================================================\n                           TROUBLESHOOTING\n================================================================================\n\nDROPS NOT WORKING:\n1. Check server console for error messages\n2. Verify JSON syntax (use online JSON validator)\n3. Ensure mod is installed and loaded\n4. Use /fishingdrops reload after changes\n5. Test with dropChance: 100.0 for guaranteed triggers\n6. Check that required conditions are met (weather, biome, etc.)\n\nCOMMANDS NOT EXECUTING:\n1. Check command syntax and permissions\n2. Verify placeholder usage ({player}, etc.)\n3. Test commands manually in server console\n4. Check cooldowns aren't preventing execution\n5. Ensure commandChance is set appropriately\n\nMODDED ITEMS NOT WORKING:\n1. Verify correct mod:item format (e.g., \"thermal:silver_ingot\")\n2. Check if mod is installed and loaded\n3. Use /give command to test item IDs\n4. Check mod's documentation for correct item names\n5. Ensure mod is loaded before EntityFishingDrops\n\nJSON SYNTAX ERRORS:\n1. Use online JSON validator\n2. Check for missing commas, quotes, brackets\n3. Ensure proper escaping of quotes in NBT data\n4. Remove trailing commas from last entries\n5. Verify all strings are properly quoted\n\nEVENT ISSUES:\n1. Check Active_Events.json for enabled events\n2. Verify event folder exists and has JSON files\n3. Use /fishingdrops event <name> false then true to reset\n4. Check server logs for loading errors\n5. Ensure event names match folder names exactly\n\nCLEAN JSON NOT GENERATING:\n1. Ensure you're using the latest version\n2. Delete existing files to regenerate clean versions\n3. Check that only needed fields are being set in code\n4. Verify Gson configuration excludes null values\n\n================================================================================\n                              SUPPORT\n================================================================================\n\nFor additional help:\n- Check server console logs for detailed error messages\n- Test configurations in creative mode for faster iteration\n- Start with simple examples and add complexity gradually\n- Use /fishingdrops reload frequently during testing\n- Backup configurations before making major changes\n\nThe mod generates clean, minimal JSON files that only include the fields you\nactually use, making them easier to read and maintain.\n\nDEBUGGING TIPS:\n- Enable debug logging for detailed information\n- Test one configuration at a time\n- Use simple drop chances (like 100.0) during testing\n- Verify item IDs with /give commands first\n- Check that events are properly enabled\n\nRemember: Always backup your configurations before making major changes!\n\n================================================================================\n";
    }
}

